/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.chathead;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.os.IBinder;
import android.os.Parcelable;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.MainActivity;
import io.intercom.android.sdk.chathead.NotificationsStateHolder;
import io.intercom.android.sdk.gcm.GcmIntentService;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.APIModels.Conversation;
import io.intercom.android.sdk.models.Events.ReadEvent;
import io.intercom.android.sdk.models.Events.UnreadConversationsEvent;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.Prefs;
import java.util.List;

@TargetApi(value=15)
public class NotificationsService
extends Service
implements View.OnTouchListener,
Animation.AnimationListener {
    public static final String NOTIFICATION_VISIBILITY = "chatehadVisibility";
    private static final int TOP_BORDER = 400;
    private static final int BOTTOM_BORDER = 100;
    private static boolean previewIsVisible = false;
    private WindowManager windowManager;
    private RelativeLayout rootView;
    private WindowManager.LayoutParams params;
    private boolean mBound;
    private ImageView notificationAvatar;
    private TextView notificationText;
    private TextView indicatorText;
    private FrameLayout notificationContainer;
    private FrameLayout indicatorLayout;
    private double aspectRatio;
    private int initialY;
    private float initialTouchY;
    private int unreadCount;
    private List<Conversation> conversations;
    private String currentlyDisplayedConversationId;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                ((NotificationsService)NotificationsService.this).params.y = context.getResources().getConfiguration().orientation == 1 ? (int)((double)((NotificationsService)NotificationsService.this).params.y * NotificationsService.this.aspectRatio) : (int)((double)((NotificationsService)NotificationsService.this).params.y / NotificationsService.this.aspectRatio);
                NotificationsService.this.checkBoundaries(NotificationsService.this.params);
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        Bridge.init(this.getApplicationContext());
        this.rootView = Prefs.isLeftAligned(this.getApplicationContext()) ? (RelativeLayout)LayoutInflater.from((Context)this).inflate(R.layout.intercomsdk_chathead_layout_left_aligned, null) : (RelativeLayout)LayoutInflater.from((Context)this).inflate(R.layout.intercomsdk_chathead_layout_right_aligned, null);
        this.conversations = NotificationsStateHolder.getInstance().getUnreadConversations();
        this.unreadCount = this.conversations.size();
        this.currentlyDisplayedConversationId = "";
        this.mBound = false;
        this.params = new WindowManager.LayoutParams(-2, -2, 2002, 520, -3);
        this.params.gravity = Prefs.getPresentationMode(this.getApplicationContext()).getGravity();
        this.params.x = 10;
        this.params.y = 100;
        this.windowManager = (WindowManager)this.getSystemService("window");
        this.windowManager.addView((View)this.rootView, (ViewGroup.LayoutParams)this.params);
        this.initializeChathead();
        Bridge.getBus().register((Object)this);
        Bridge.getPoller().startChatheadPolling();
        Logger.INTERNAL("notificationAvatar", "on create");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Logger.INTERNAL("notificationAvatar", "on start command");
        NotificationsStateHolder stateHolder = NotificationsStateHolder.getInstance();
        stateHolder.setNotificationPreviewEnabled(intent.getBooleanExtra(NOTIFICATION_VISIBILITY, stateHolder.isNotificationPreviewEnabled()));
        this.checkConversations();
        return 2;
    }

    public IBinder onBind(Intent intent) {
        Logger.INTERNAL("notificationAvatar", "on bind");
        this.mBound = true;
        this.hideChathead();
        Bridge.getPoller().startInboxPolling();
        return null;
    }

    public boolean onUnbind(Intent intent) {
        Logger.INTERNAL("notificationAvatar", "on unbind");
        this.mBound = false;
        this.checkConversations();
        Bridge.getPoller().startChatheadPolling();
        return true;
    }

    public void onRebind(Intent intent) {
        Logger.INTERNAL("notificationAvatar", "on rebind");
        this.mBound = true;
        this.hideChathead();
        Bridge.getPoller().startInboxPolling();
        super.onRebind(intent);
    }

    public void onDestroy() {
        Logger.INTERNAL("notificationAvatar", "on destroy");
        if (this.rootView != null) {
            this.windowManager.removeView((View)this.rootView);
        }
        Bridge.getBus().unregister((Object)this);
        Bridge.getPoller().endPolling();
        this.unregisterReceiver(this.mBroadcastReceiver);
        this.conversations.clear();
        previewIsVisible = false;
        super.onDestroy();
    }

    public void initializeChathead() {
        Display display = this.windowManager.getDefaultDisplay();
        Point windowSize = new Point();
        display.getSize(windowSize);
        this.aspectRatio = windowSize.x >= windowSize.y ? (double)windowSize.x / (double)windowSize.y : (double)windowSize.y / (double)windowSize.x;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.registerReceiver(this.mBroadcastReceiver, filter);
        this.notificationAvatar = (ImageView)this.rootView.findViewById(R.id.avatar);
        this.notificationContainer = (FrameLayout)this.rootView.findViewById(R.id.notification_container);
        this.notificationText = (TextView)this.rootView.findViewById(R.id.notification_text);
        this.indicatorText = (TextView)this.rootView.findViewById(R.id.indicator_text);
        this.indicatorLayout = (FrameLayout)this.rootView.findViewById(R.id.indicator_container);
        ImageView unreadIndicator = (ImageView)this.rootView.findViewById(R.id.unreadImageView);
        unreadIndicator.setColorFilter(this.getResources().getColor(R.color.intercomsdk_red));
        this.notificationText.setTypeface(FontUtils.getTypeface("Roboto-Medium.ttf", (Context)this));
        this.indicatorText.setTypeface(FontUtils.getTypeface("Roboto-Medium.ttf", (Context)this));
        this.notificationAvatar.setOnTouchListener((View.OnTouchListener)this);
        this.notificationContainer.setOnTouchListener((View.OnTouchListener)this);
    }

    private void getUnreadConversations() {
        Bridge.getApi().getUnreadConversations();
    }

    @Subscribe
    public void unreadCountUpdated(UnreadConversationsEvent event) {
        Intent serviceIntent = new Intent((Context)this, GcmIntentService.class);
        serviceIntent.setAction("intercom_sdk_remove_notification");
        this.startService(serviceIntent);
        this.conversations.clear();
        this.conversations.addAll(event.getResponse().getConversations());
        this.unreadCount = event.getResponse().getTotalUnreadCount();
        this.checkConversations();
    }

    @Subscribe
    public void conversationMarkedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversations) {
            if (!conversation.getId().equals(event.getConversationId())) continue;
            this.conversations.remove(conversation);
            --this.unreadCount;
            break;
        }
        if (this.conversations.size() == 1 && this.unreadCount > this.conversations.size()) {
            this.getUnreadConversations();
        }
    }

    private void checkConversations() {
        if (NotificationsStateHolder.getInstance().isNotificationPreviewEnabled()) {
            if (this.conversations.isEmpty()) {
                this.hideChathead();
            } else {
                Conversation conversation = this.conversations.get(0);
                String messageStyle = conversation.getLastPart().getMessageStyle();
                if ("announcement".equals(messageStyle) || "small-announcement".equals(messageStyle)) {
                    Intent intent = new Intent((Context)this, MainActivity.class);
                    intent.putExtra("CreateConversation", (Parcelable)conversation);
                    intent.addFlags(0x10000000);
                    this.startActivity(intent);
                } else if ("chat".equals(messageStyle)) {
                    this.updateChatHeadUI(conversation);
                }
            }
        } else {
            this.hideChathead();
        }
    }

    private void updateChatHeadUI(Conversation conversation) {
        boolean shouldFadeIn = this.rootView.getVisibility() != 0;
        AvatarUtils.createAvatar(conversation.getLastAdmin().getAvatar(), this.notificationAvatar, (Context)this);
        String lastAdminText = conversation.getLastAdminPart().getSummary();
        if (!lastAdminText.isEmpty()) {
            this.notificationText.setText((CharSequence)lastAdminText);
        } else {
            this.notificationText.setText(R.string.intercomsdk_image_attached);
        }
        this.indicatorText.setText((CharSequence)String.valueOf(this.unreadCount));
        this.showChathead();
        if (shouldFadeIn) {
            this.fadeInChatHead();
        }
        if (!this.currentlyDisplayedConversationId.equals(conversation.getId())) {
            this.animateTextBubble();
        }
        this.currentlyDisplayedConversationId = conversation.getId();
    }

    private void showChathead() {
        if (!this.mBound) {
            Logger.INTERNAL("notificationAvatar", "showing notificationAvatar");
            this.rootView.setVisibility(0);
            this.notificationAvatar.setVisibility(0);
            this.indicatorLayout.setVisibility(0);
            previewIsVisible = true;
        }
    }

    private void hideChathead() {
        Logger.INTERNAL("notificationAvatar", "hiding notificationAvatar");
        this.rootView.setVisibility(8);
        this.notificationAvatar.setVisibility(8);
        this.indicatorLayout.setVisibility(8);
        previewIsVisible = false;
    }

    private void fadeInChatHead() {
        Animation chatheadFadeIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.intercomsdk_chathead_fade_in_anim);
        this.notificationAvatar.startAnimation(chatheadFadeIn);
        Animation badgeFadeIn = AnimationUtils.loadAnimation((Context)this, (int)R.anim.intercomsdk_unread_badge_fade_in_anim);
        this.indicatorLayout.startAnimation(badgeFadeIn);
    }

    private void animateTextBubble() {
        if (!Prefs.isLeftAligned(this.getApplicationContext())) {
            return;
        }
        Animation textAnim = AnimationUtils.loadAnimation((Context)this, (int)R.anim.intercomsdk_chathead_text_notification_left_aligned_anim);
        this.notificationContainer.getBackground().setColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.MULTIPLY);
        this.notificationContainer.setVisibility(0);
        this.notificationContainer.startAnimation(textAnim);
        textAnim.setAnimationListener((Animation.AnimationListener)this);
    }

    private void checkBoundaries(WindowManager.LayoutParams params) {
        WindowManager wm = (WindowManager)this.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point windowSize = new Point();
        display.getSize(windowSize);
        if (params.y < 100) {
            params.y = 100;
        }
        if (params.y > windowSize.y - 400) {
            params.y = windowSize.y - 400;
        }
        wm.updateViewLayout((View)this.rootView, (ViewGroup.LayoutParams)params);
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        this.notificationContainer.setVisibility(8);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.initialY = this.params.y;
                this.initialTouchY = event.getRawY();
                return true;
            }
            case 1: {
                if (this.initialY == this.params.y) {
                    this.rootView.setVisibility(8);
                    Intent intent = new Intent((Context)this, MainActivity.class);
                    intent.putExtra("CreateConversation", (Parcelable)this.conversations.get(0));
                    intent.putExtra("intercomsdk-unreadCount", this.unreadCount);
                    intent.putExtra("intercomsdk-isRead", false);
                    intent.addFlags(0x10000000);
                    this.startActivity(intent);
                }
                return true;
            }
            case 2: {
                this.params.y = this.initialY - (int)(event.getRawY() - this.initialTouchY);
                this.checkBoundaries(this.params);
                return true;
            }
        }
        return false;
    }

    public static boolean isChatheadVisible() {
        return previewIsVisible;
    }
}

