/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.Html;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import io.intercom.blocks.blockInterfaces.SubheadngBlock;

public class Subheading
implements SubheadngBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public Subheading(Context context, StyleType style) {
        this.context = context;
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addSubheading(String text, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        switch (this.style) {
            case admin: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_subheading, parent, false);
                break;
            }
            case announcement: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_subheading, parent, false);
                int color2 = Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor());
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                break;
            }
            case welcome: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_subheading, parent, false);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_user_subheading, parent, false);
            }
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText((CharSequence)Html.fromHtml((String)text));
        if (isLastObject) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(textview.getLayoutParams());
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, 0);
            params.gravity = 0x800003;
            textview.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return textview;
    }
}

