/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.ui.preview.data;

import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewFile;", "Landroid/os/Parcelable;", "uri", "Landroid/net/Uri;", "<init>", "(Landroid/net/Uri;)V", "getUri", "()Landroid/net/Uri;", "getMimeType", "", "context", "Landroid/content/Context;", "isImage", "", "isVideo", "LocalFile", "NetworkFile", "Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewFile$LocalFile;", "Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewFile$NetworkFile;", "intercom-sdk-ui_release"})
@Parcelize
@StabilityInferred(parameters=0)
public abstract class IntercomPreviewFile
implements Parcelable {
    @NotNull
    private final Uri uri;
    public static final int $stable = 8;

    private IntercomPreviewFile(Uri uri) {
        this.uri = uri;
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    @NotNull
    public final String getMimeType(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IntercomPreviewFile intercomPreviewFile = this;
        if (intercomPreviewFile instanceof LocalFile) {
            string = context.getContentResolver().getType(this.uri);
            if (string == null) {
                string = "application/*";
            }
        } else if (intercomPreviewFile instanceof NetworkFile) {
            string = ((NetworkFile)this).getMimeType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public final boolean isImage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.contains$default((CharSequence)this.getMimeType(context), (CharSequence)"image", (boolean)false, (int)2, null);
    }

    public final boolean isVideo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.contains$default((CharSequence)this.getMimeType(context), (CharSequence)"video", (boolean)false, (int)2, null);
    }

    public /* synthetic */ IntercomPreviewFile(Uri uri, DefaultConstructorMarker $constructor_marker) {
        this(uri);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c7\u0001J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d7\u0003J\t\u0010\u0010\u001a\u00020\u000bH\u00d7\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d7\u0001J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewFile$LocalFile;", "Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewFile;", "fileUri", "Landroid/net/Uri;", "<init>", "(Landroid/net/Uri;)V", "getFileUri", "()Landroid/net/Uri;", "component1", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "intercom-sdk-ui_release"})
    @StabilityInferred(parameters=0)
    public static final class LocalFile
    extends IntercomPreviewFile {
        @NotNull
        private final Uri fileUri;
        public static final int $stable = 8;
        @NotNull
        public static final Parcelable.Creator<LocalFile> CREATOR;

        public LocalFile(@NotNull Uri fileUri) {
            Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
            super(fileUri, null);
            this.fileUri = fileUri;
        }

        @NotNull
        public final Uri getFileUri() {
            return this.fileUri;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeParcelable((Parcelable)this.fileUri, flags);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final Uri component1() {
            return this.fileUri;
        }

        @NotNull
        public final LocalFile copy(@NotNull Uri fileUri) {
            Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
            return new LocalFile(fileUri);
        }

        public static /* synthetic */ LocalFile copy$default(LocalFile localFile, Uri uri, int n, Object object) {
            if ((n & 1) != 0) {
                uri = localFile.fileUri;
            }
            return localFile.copy(uri);
        }

        @NotNull
        public String toString() {
            return "LocalFile(fileUri=" + this.fileUri + ')';
        }

        public int hashCode() {
            return this.fileUri.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocalFile)) {
                return false;
            }
            LocalFile localFile = (LocalFile)other;
            return Intrinsics.areEqual((Object)this.fileUri, (Object)localFile.fileUri);
        }

        static {
            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<LocalFile> {
                public final LocalFile[] newArray(int size) {
                    return new LocalFile[size];
                }

                public final LocalFile createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new LocalFile((Uri)parcel.readParcelable(LocalFile.class.getClassLoader()));
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c7\u0001J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d7\u0003J\t\u0010\u0013\u001a\u00020\u000eH\u00d7\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d7\u0001J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001a"}, d2={"Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewFile$NetworkFile;", "Lio/intercom/android/sdk/ui/preview/data/IntercomPreviewFile;", "url", "", "mimeType", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "getMimeType", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "intercom-sdk-ui_release"})
    @StabilityInferred(parameters=1)
    public static final class NetworkFile
    extends IntercomPreviewFile {
        @NotNull
        private final String url;
        @NotNull
        private final String mimeType;
        public static final int $stable;
        @NotNull
        public static final Parcelable.Creator<NetworkFile> CREATOR;

        public NetworkFile(@NotNull String url, @NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Uri uri = Uri.parse((String)url);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
            super(uri, null);
            this.url = url;
            this.mimeType = mimeType;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getMimeType() {
            return this.mimeType;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.url);
            dest.writeString(this.mimeType);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final String component2() {
            return this.mimeType;
        }

        @NotNull
        public final NetworkFile copy(@NotNull String url, @NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return new NetworkFile(url, mimeType);
        }

        public static /* synthetic */ NetworkFile copy$default(NetworkFile networkFile, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = networkFile.url;
            }
            if ((n & 2) != 0) {
                string2 = networkFile.mimeType;
            }
            return networkFile.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "NetworkFile(url=" + this.url + ", mimeType=" + this.mimeType + ')';
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + this.mimeType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NetworkFile)) {
                return false;
            }
            NetworkFile networkFile = (NetworkFile)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)networkFile.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mimeType, (Object)networkFile.mimeType);
        }

        static {
            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<NetworkFile> {
                public final NetworkFile[] newArray(int size) {
                    return new NetworkFile[size];
                }

                public final NetworkFile createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new NetworkFile(parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }
    }
}

