/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.ui.common;

import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.activity.result.contract.ActivityResultContract;
import io.intercom.android.sdk.ui.common.MediaPickerButtonKt;
import io.intercom.android.sdk.ui.common.MediaType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\u001b\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001d"}, d2={"Lio/intercom/android/sdk/ui/common/IntercomMediaPicker;", "Landroidx/activity/result/contract/ActivityResultContract;", "", "", "Landroid/net/Uri;", "mediaType", "Lio/intercom/android/sdk/ui/common/MediaType;", "maxSelectionCount", "", "(Lio/intercom/android/sdk/ui/common/MediaType;I)V", "supportedImageTypes", "", "[Ljava/lang/String;", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "getIntent", "getMimeType", "()[Ljava/lang/String;", "getNativePickerIntent", "getPhotoPickerIntent", "supportedTypes", "([Ljava/lang/String;)Landroid/content/Intent;", "parseResult", "resultCode", "intent", "getClipDataUris", "intercom-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nMediaPickerButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaPickerButton.kt\nio/intercom/android/sdk/ui/common/IntercomMediaPicker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,243:1\n1549#2:244\n1620#2,3:245\n37#3,2:248\n*S KotlinDebug\n*F\n+ 1 MediaPickerButton.kt\nio/intercom/android/sdk/ui/common/IntercomMediaPicker\n*L\n165#1:244\n165#1:245,3\n171#1:248,2\n*E\n"})
final class IntercomMediaPicker
extends ActivityResultContract<String, List<? extends Uri>> {
    @NotNull
    private final MediaType mediaType;
    private final int maxSelectionCount;
    @NotNull
    private final String[] supportedImageTypes;

    public IntercomMediaPicker(@NotNull MediaType mediaType, int maxSelectionCount) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        this.mediaType = mediaType;
        this.maxSelectionCount = maxSelectionCount;
        String[] stringArray = new String[]{"image/jpg", "image/jpeg", "image/png", "image/gif", "image/bmp"};
        this.supportedImageTypes = stringArray;
    }

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.getIntent(input);
    }

    @NotNull
    public List<Uri> parseResult(int resultCode, @Nullable Intent intent) {
        Object object;
        Intent it = object = intent;
        boolean bl = false;
        Intent intent2 = resultCode == -1 ? object : null;
        return intent2 != null && (object = this.getClipDataUris(intent2)) != null ? object : CollectionsKt.emptyList();
    }

    private final Intent getIntent(String input) {
        Intent intent;
        MediaType mediaType = this.mediaType;
        if (Intrinsics.areEqual((Object)mediaType, (Object)MediaType.All.INSTANCE) ? true : mediaType instanceof MediaType.Custom) {
            Intent intent2 = new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").putExtra("android.intent.extra.MIME_TYPES", this.getMimeType()).setType(input).putExtra("android.intent.extra.ALLOW_MULTIPLE", this.maxSelectionCount > 1);
            intent = intent2;
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n                Intent\u2026nCount > 1)\n            }");
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)MediaType.DocumentOnly.INSTANCE)) {
            intent = this.getNativePickerIntent();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)MediaType.ImageAndVideo.INSTANCE)) {
            intent = MediaPickerButtonKt.isPhotoPickerAvailable() ? this.getPhotoPickerIntent(this.getMimeType()) : this.getNativePickerIntent();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)MediaType.ImageOnly.INSTANCE)) {
            intent = MediaPickerButtonKt.isPhotoPickerAvailable() ? this.getPhotoPickerIntent(this.getMimeType()) : this.getNativePickerIntent();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)MediaType.VideOnly.INSTANCE)) {
            intent = MediaPickerButtonKt.isPhotoPickerAvailable() ? this.getPhotoPickerIntent(this.getMimeType()) : this.getNativePickerIntent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return intent;
    }

    /*
     * Unable to fully structure code
     */
    private final String[] getMimeType() {
        block13: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    var1_1 = this.mediaType;
                                    if (!Intrinsics.areEqual((Object)var1_1, (Object)MediaType.All.INSTANCE)) break block12;
                                    var2_2 = new String[]{"video/*", "application/*"};
                                    v0 = (String[])ArraysKt.plus((Object[])this.supportedImageTypes, (Object[])var2_2);
                                    break block13;
                                }
                                if (!Intrinsics.areEqual((Object)var1_1, (Object)MediaType.DocumentOnly.INSTANCE)) break block14;
                                var2_3 = new String[]{"application/*"};
                                v0 = var2_3;
                                break block13;
                            }
                            if (!Intrinsics.areEqual((Object)var1_1, (Object)MediaType.ImageAndVideo.INSTANCE)) break block15;
                            var2_4 = new String[]{"video/*"};
                            v0 = (String[])ArraysKt.plus((Object[])this.supportedImageTypes, (Object[])var2_4);
                            break block13;
                        }
                        if (!Intrinsics.areEqual((Object)var1_1, (Object)MediaType.ImageOnly.INSTANCE)) break block16;
                        v0 = this.supportedImageTypes;
                        break block13;
                    }
                    if (!Intrinsics.areEqual((Object)var1_1, (Object)MediaType.VideOnly.INSTANCE)) break block17;
                    var2_5 = new String[]{"video/*"};
                    v0 = var2_5;
                    break block13;
                }
                if (!(var1_1 instanceof MediaType.Custom)) break block18;
                $this$map$iv = ((MediaType.Custom)this.mediaType).getSupportedType();
                $i$f$map = false;
                var4_8 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    block19: {
                        var9_13 = (String)item$iv$iv;
                        var12_16 = destination$iv$iv;
                        $i$a$-map-IntercomMediaPicker$getMimeType$1 = false;
                        var11_15 = it;
                        switch (var11_15.hashCode()) {
                            case 105441: {
                                if (!var11_15.equals("jpg")) {
                                    ** break;
                                }
                                ** GOTO lbl58
                            }
                            case 108273: {
                                if (var11_15.equals("mp4")) break;
                                ** break;
                            }
                            case 102340: {
                                if (!var11_15.equals("gif")) {
                                    ** break;
                                }
                                ** GOTO lbl58
                            }
                            case 108308: {
                                if (var11_15.equals("mov")) break;
                                ** break;
                            }
                            case 111145: {
                                if (!var11_15.equals("png")) {
                                    ** break;
                                }
                                ** GOTO lbl58
                            }
                            case 3268712: {
                                if (!var11_15.equals("jpeg")) ** break;
lbl58:
                                // 4 sources

                                v1 = "image/" + (String)it;
                                break block19;
                            }
                        }
                        v1 = "video/" + (String)it;
                        break block19;
lbl62:
                        // 7 sources

                        v1 = "application/" + (String)it;
                    }
                    var12_16.add(v1);
                }
                $this$toTypedArray$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                v0 = thisCollection$iv.toArray(new String[0]);
                break block13;
            }
            throw new NoWhenBranchMatchedException();
        }
        return v0;
    }

    private final Intent getPhotoPickerIntent(String[] supportedTypes) {
        Intent intent;
        Intent $this$getPhotoPickerIntent_u24lambda_u243 = intent = new Intent("android.provider.action.PICK_IMAGES");
        boolean bl = false;
        $this$getPhotoPickerIntent_u24lambda_u243.putExtra("android.intent.extra.MIME_TYPES", supportedTypes);
        if (this.maxSelectionCount > 1) {
            if (!(this.maxSelectionCount <= MediaStore.getPickImagesMaxLimit())) {
                boolean bl2 = false;
                String string = "Max items must be less or equals MediaStore.getPickImagesMaxLimit()";
                throw new IllegalArgumentException(string.toString());
            }
            $this$getPhotoPickerIntent_u24lambda_u243.putExtra("android.provider.extra.PICK_IMAGES_MAX", this.maxSelectionCount);
        }
        return intent;
    }

    private final Intent getNativePickerIntent() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").setType((String)ArraysKt.first((Object[])this.getMimeType())).putExtra("android.intent.extra.MIME_TYPES", this.getMimeType()).addFlags(1).putExtra("android.intent.extra.ALLOW_MULTIPLE", this.maxSelectionCount > 1);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Intent.ACTION_GET\u2026E, maxSelectionCount > 1)");
        return intent;
    }

    private final List<Uri> getClipDataUris(Intent $this$getClipDataUris) {
        LinkedHashSet<Uri> resultSet = new LinkedHashSet<Uri>();
        Uri uri = $this$getClipDataUris.getData();
        if (uri != null) {
            Uri data = uri;
            boolean bl = false;
            resultSet.add(data);
        }
        ClipData clipData = $this$getClipDataUris.getClipData();
        if (clipData == null && resultSet.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (clipData != null) {
            int n = clipData.getItemCount();
            for (int i = 0; i < n; ++i) {
                Uri uri2 = clipData.getItemAt(i).getUri();
                if (uri2 == null) continue;
                resultSet.add(uri2);
            }
        }
        return new ArrayList(resultSet);
    }
}

