/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.iid.InstanceID;
import io.intercom.android.sdk.IntercomPushManager;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.IntercomPushClient;
import io.intercom.android.sdk.twig.Twig;
import java.io.IOException;

public class IntercomGcmImplementation
implements IntercomPushManager.GcmImplementation {
    private final IntercomPushClient pushClient = new IntercomPushClient();
    private final Twig twig = LumberMill.getLogger();

    public void registerToken(Application application) {
        InstanceID instanceId = InstanceID.getInstance((Context)application);
        String senderId = IntercomPushManager.getSenderId((Context)application);
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            this.printTokenError();
        } else {
            try {
                String token = instanceId.getToken(senderId, "GCM", null);
                this.pushClient.sendTokenToIntercom(application, token);
            }
            catch (IOException e) {
                this.twig.e("Upload of GCM token failed: " + e.getMessage(), new Object[0]);
            }
        }
    }

    private void printTokenError() {
        this.twig.e("Intercom push registration failed. Please make sure the following string is in your strings.xml file: <string name=\"intercom_gcm_sender_id\">YOUR_SENDER_ID</string>", new Object[0]);
    }

    static {
        IntercomPushManager.gcmImplementation = new IntercomGcmImplementation();
    }
}

