/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.google.android.gms.iid.InstanceID;
import io.intercom.android.sdk.Gcm;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.user.DeviceData;
import java.io.IOException;

public class IntercomGcmRegistrationService
extends IntentService {
    public IntercomGcmRegistrationService() {
        super("Intercom GCM Registration Service");
    }

    public void onHandleIntent(Intent intent) {
        InstanceID instanceId = InstanceID.getInstance((Context)this);
        String senderId = Gcm.getSenderId((Context)this);
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            this.printTokenError();
        } else {
            try {
                this.sendTokenToIntercom(instanceId.getToken(senderId, "GCM", null));
            }
            catch (IOException e) {
                IntercomLogger.e((String)("Upload failed: " + e.getMessage()));
            }
        }
    }

    private void sendTokenToIntercom(String token) {
        Context context = this.getApplicationContext();
        if (!DeviceData.hasCachedPushToken((Context)context, (String)token)) {
            Injector.get().getApi().setGcmPushKey(token);
            DeviceData.cachePushToken((Context)context, (String)token);
        }
    }

    private void printTokenError() {
        IntercomLogger.e((String)"Intercom push registration failed. Please make sure the following string is in your strings.xml file: <string name=\"intercom_gcm_sender_id\">YOUR_SENDER_ID</string>");
    }
}

