/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import io.intercom.android.sdk.gcm.GcmNotificationFactory;
import io.intercom.android.sdk.gcm.PushNotification;
import java.util.ArrayList;
import java.util.List;

class GcmNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;
    private static final List<PushNotification> notifications = new ArrayList<PushNotification>();
    private final GcmNotificationFactory gcmNotificationFactory = new GcmNotificationFactory();
    private final NotificationManager notificationManager;

    GcmNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    void killNotifications() {
        this.notificationManager.cancel(9999997);
        notifications.clear();
    }

    protected List<PushNotification> getNotifications() {
        return notifications;
    }

    void createPushOnlyNotification(PushNotification notification, Context context) {
        Notification gemNotification = this.gcmNotificationFactory.createPushOnlyNotification(notification, context);
        String pushOnlyConversationId = notification.getPushOnlyConversationId();
        this.notificationManager.notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), gemNotification);
    }

    void createNotification(PushNotification notification, String messageType, Context context) {
        if ("gcm".equals(messageType)) {
            notifications.add(notification);
            Notification gemNotification = notifications.size() == 1 ? this.gcmNotificationFactory.createSingleNotification(notifications.get(0), context) : this.gcmNotificationFactory.createGroupedNotification(notifications, context);
            this.notificationManager.notify(9999997, gemNotification);
        }
    }
}

