/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Lifecycles;
import io.intercom.android.sdk.gcm.GcmBroadcastReceiver;
import io.intercom.android.sdk.gcm.GcmNotificationManager;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.PushNotification;

public class GcmIntentService
extends IntentService {
    private static final String TAG = "GcmIntentService";
    private GcmNotificationManager gcmNotificationManager;

    public GcmIntentService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        this.gcmNotificationManager = new GcmNotificationManager((NotificationManager)this.getSystemService("notification"));
    }

    protected void onHandleIntent(Intent intent) {
        Bridge.init((Context)this.getApplicationContext());
        if (!Bridge.getIdentityStore().userIdentityExists()) {
            this.removeAllNotifications();
            Logger.INFO((String)"Can't create GCM message we have no user identity. This can be caused by messages being sent to a logged out user.");
        } else if (intent != null) {
            if ("intercom_sdk_remove_notification".equals(intent.getAction())) {
                if (!this.gcmNotificationManager.getNotifications().isEmpty()) {
                    Logger.INFO((String)"Removing Intercom GCM messages.");
                }
                this.removeAllNotifications();
            } else {
                Bundle extras = intent.getExtras();
                if (extras != null && !extras.isEmpty()) {
                    Logger.INTERNAL((String)TAG, (String)("Notification Data Json :" + extras.getString("message")));
                    PushNotification notification = new PushNotification(extras);
                    if (!notification.getReceiver().isEmpty() && notification.getReceiver().equals("intercom_sdk")) {
                        if (Lifecycles.isAppBackgrounded()) {
                            this.gcmNotificationManager.addNotification(notification);
                            this.gcmNotificationManager.createNotification(GoogleCloudMessaging.getInstance((Context)this).getMessageType(intent), (Context)this);
                        } else {
                            Logger.INFO((String)"Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.");
                        }
                    } else {
                        Logger.INFO((String)"This is not a Intercom GCM message");
                    }
                } else {
                    Logger.ERROR((String)"The GCM intent contained no data");
                }
            }
        } else {
            Logger.WARNING((String)"The intent sent to the GCMIntentService was null, we were not able to create your GCM Notification");
        }
        this.completeWakeLock(intent);
    }

    private void removeAllNotifications() {
        this.gcmNotificationManager.killNotifications();
    }

    private void completeWakeLock(Intent intent) {
        if (intent != null) {
            GcmBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
    }
}

