/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.gcm.R;
import io.intercom.android.sdk.gcm.models.PushNotification;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.transforms.RoundTransform;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.com.squareup.picasso.Picasso;
import io.intercom.com.squareup.picasso.Transformation;
import java.io.IOException;
import java.util.List;

public class GcmNotificationBuilder {
    private static final String CONVERSATION_URI = "conversation_id=%s";

    protected void createSingleNotification(PushNotification notification, NotificationManager notificationManager, int NOTIFICATION_ID, Context context) {
        Uri destination = Uri.parse((String)String.format("intercom_sdk/conversation_id=%s", notification.getConversationId()));
        NotificationCompat.Builder builder = this.getBaseNotificationBuilder(notification.getTitle(context), notification.getMessage(), destination, notification.getPushOnlyConversationId(), notification.getPriority(), context);
        builder.setLargeIcon(this.generateAvatar(notification, context));
        builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)notification.getMessage()));
        notificationManager.notify(NOTIFICATION_ID, builder.build());
    }

    protected void createGroupedNotification(List<PushNotification> notifications, NotificationManager notificationManager, int NOTIFICATION_ID, Context context) {
        Uri destination = Uri.parse((String)"intercom_sdk/multiple_notifications");
        NotificationCompat.Builder builder = this.getBaseNotificationBuilder(context.getString(R.string.intercomsdk_groupTitle), context.getResources().getQuantityString(R.plurals.intercomsdk_groupMessage, notifications.size(), new Object[]{notifications.size()}), destination, -1, notifications.get(notifications.size() - 1).getPriority(), context);
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle((CharSequence)context.getString(R.string.intercomsdk_groupExpandedTitle));
        for (PushNotification notification : notifications) {
            SpannableString spannable = new SpannableString((CharSequence)(notification.getName() + ": " + notification.getMessage()));
            spannable.setSpan((Object)new StyleSpan(1), 0, notification.getName().length(), 33);
            inboxStyle.addLine((CharSequence)spannable);
        }
        builder.setStyle((NotificationCompat.Style)inboxStyle);
        notificationManager.notify(NOTIFICATION_ID, builder.build());
    }

    protected void createPushOnlyNotification(PushNotification notification, NotificationManager notificationManager, int NOTIFICATION_ID, Context context) {
        Uri destination = Uri.parse((String)notification.getUri());
        NotificationCompat.Builder builder = this.getBaseNotificationBuilder(notification.getTitle(context), notification.getMessage(), destination, notification.getPushOnlyConversationId(), notification.getPriority(), context);
        builder.setColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
        builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)notification.getMessage()));
        notificationManager.notify(NOTIFICATION_ID, builder.build());
    }

    @TargetApi(value=16)
    private NotificationCompat.Builder getBaseNotificationBuilder(String title, String content, Uri destination, int conversationId, int priority, Context context) {
        Intent newIntent;
        PackageManager packageManager = context.getPackageManager();
        try {
            newIntent = packageManager.getLaunchIntentForPackage(context.getPackageName());
            if (newIntent == null) {
                throw new PackageManager.NameNotFoundException();
            }
            newIntent.addCategory("android.intent.category.LAUNCHER");
            newIntent.setData(destination);
            if (conversationId != -1) {
                newIntent.putExtra("push_only_convo_id", conversationId);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            newIntent = new Intent();
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)conversationId, (Intent)newIntent, (int)0x10000000);
        NotificationCompat.Builder notification = new NotificationCompat.Builder(context).setSmallIcon(this.getAppIconResId(context)).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setAutoCancel(true).setDefaults(3).setLights(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), 500, 2000).setContentIntent(pendingIntent);
        notification.setPriority(priority);
        return notification;
    }

    private Bitmap generateAvatar(PushNotification notification, Context context) {
        Bitmap defaultBitmap = AvatarUtils.getNotificationDefaultBitmap((Context)context);
        if (TextUtils.isEmpty((CharSequence)notification.getImageUrl()) && !TextUtils.isEmpty((CharSequence)notification.getName())) {
            return AvatarUtils.getTextBitmap((String)NameUtils.getInitials((String)notification.getName()), (String)notification.getColor(), (Context)context);
        }
        BitmapDrawable defaultDrawable = new BitmapDrawable(context.getResources(), defaultBitmap);
        try {
            return Picasso.with((Context)context).load(notification.getImageUrl()).placeholder((Drawable)defaultDrawable).error((Drawable)defaultDrawable).transform((Transformation)new RoundTransform()).get();
        }
        catch (IOException e) {
            IntercomLogger.DEBUG((String)"Failed to retrieve the notification image");
            return defaultBitmap;
        }
    }

    private int getAppIconResId(Context context) {
        int appResId = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0).getInt("INTERCOM_SDK_PUSH_LOGO", -1);
        if (appResId == -1) {
            appResId = R.drawable.intercomsdk_default_push;
        }
        return appResId;
    }
}

