/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm.models;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.gcm.R;

public class PushNotification {
    private final String conversationId;
    private final String message;
    private final String body;
    private final String authorName;
    private final String imageUrl;
    private final String avatarColor;
    private final String conversationPartType;
    private final String appId;
    private final String appName;
    private final String receiver;
    private final String intercomPushType;
    private final String uri;
    private final String pushOnlyConversationId;
    private final String title;
    private final int priority;
    public static final String PUSH_ONLY = "push_only";

    @SuppressLint(value={"NewApi"})
    public PushNotification(Bundle extras) {
        this.conversationId = extras.getString("conversation_id", "");
        this.message = extras.getString("message", "");
        this.body = extras.getString("body", "");
        this.authorName = extras.getString("author_name", "");
        this.avatarColor = extras.getString("avatar_color", "");
        this.imageUrl = extras.getString("image_url", "");
        this.conversationPartType = extras.getString("conversation_part_type", "");
        this.appId = extras.getString("app_id", "");
        this.appName = extras.getString("app_name", "");
        this.receiver = extras.getString("receiver", "");
        this.intercomPushType = extras.getString("intercom_push_type", "");
        this.uri = extras.getString("uri", "");
        this.pushOnlyConversationId = extras.getString("push_only_conv_id", "");
        this.title = extras.getString("title", "");
        this.priority = extras.getInt("intercom_priority_type", 1);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getMessage() {
        return !this.message.isEmpty() ? this.message : this.body;
    }

    public String getColor() {
        return this.avatarColor;
    }

    public String getType() {
        return this.conversationPartType;
    }

    public String getName() {
        return this.authorName;
    }

    public String getTitle(Context context) {
        if (!this.title.isEmpty()) {
            return this.title;
        }
        if (!this.authorName.isEmpty() && !this.appName.isEmpty()) {
            return context.getString(R.string.intercomsdk_push_title_format, new Object[]{this.authorName, this.appName});
        }
        if (!this.authorName.isEmpty()) {
            return this.authorName;
        }
        return this.appName;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public boolean isIntercomPush() {
        return !this.intercomPushType.isEmpty();
    }

    public boolean isPushOnly() {
        return PUSH_ONLY.equals(this.intercomPushType);
    }

    public String getUri() {
        return this.uri;
    }

    public int getPushOnlyConversationId() {
        try {
            return Integer.valueOf(this.pushOnlyConversationId);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getPriority() {
        return this.priority;
    }
}

