/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.app.NotificationManager;
import android.content.Context;
import io.intercom.android.sdk.gcm.GcmNotificationBuilder;
import io.intercom.android.sdk.gcm.models.PushNotification;
import java.util.ArrayList;
import java.util.List;

public class GcmNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;
    private static final List<PushNotification> notifications = new ArrayList<PushNotification>();
    private final GcmNotificationBuilder gcmNotificationBuilder = new GcmNotificationBuilder();
    private final NotificationManager notificationManager;

    protected GcmNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    protected void killNotifications() {
        this.notificationManager.cancel(9999997);
        notifications.clear();
    }

    protected List<PushNotification> getNotifications() {
        return notifications;
    }

    protected void addNotification(PushNotification notification) {
        notifications.add(notification);
    }

    protected void createPushOnlyNotification(PushNotification notification, Context context) {
        this.gcmNotificationBuilder.createPushOnlyNotification(notification, this.notificationManager, notification.getPushOnlyConversationId(), context);
    }

    protected void createNotification(String messageType, Context context) {
        if ("gcm".equals(messageType)) {
            if (notifications.size() == 1) {
                this.gcmNotificationBuilder.createSingleNotification(notifications.get(0), this.notificationManager, 9999997, context);
            } else if (notifications.size() > 1) {
                this.gcmNotificationBuilder.createGroupedNotification(notifications, this.notificationManager, 9999997, context);
            }
        }
    }
}

