/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipboardManager;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.bumptech.glide.RequestManager;
import com.intercom.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.views.holder.BlocksPartViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;

public class LinkViewHolder
extends BlocksPartViewHolder {
    private final int viewType;
    private final Provider<AppConfig> appConfigProvider;
    private final RequestManager requestManager;

    public LinkViewHolder(View itemView, int viewType, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, Provider<AppConfig> appConfigProvider, RequestManager requestManager) {
        super(itemView, conversationListener, clipboardManager);
        this.viewType = viewType;
        this.appConfigProvider = appConfigProvider;
        this.requestManager = requestManager;
        this.cellLayout.setTransitionName("link_background");
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        ColorUtils.updateInnerBorderColor(this.appConfigProvider.get(), (View)this.cellLayout);
        ViewGroup blocks = this.setUpHolderBlocks(part, this.cellLayout, this.bubble, blocksLayout);
        int horizontalPadding = ScreenUtils.dpToPx((float)16.0f, (Context)this.itemView.getContext());
        int verticalPadding = ScreenUtils.dpToPx((float)24.0f, (Context)this.itemView.getContext());
        blocks.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        this.checkForEntranceAnimation(this.viewType, part, this.networkAvatar, (View)this.cellLayout, blocks);
        if (this.networkAvatar != null) {
            this.showAvatar(part.getParticipant(), this.networkAvatar, this.appConfigProvider.get(), this.requestManager);
            this.updateAvatarMarginForCard(part);
        }
    }

    public void onClick(View v) {
        int adapterPosition = this.getAdapterPosition();
        if (adapterPosition != -1) {
            this.conversationListener.onLinkClicked(adapterPosition, (View)this.cellLayout);
        }
    }
}

