/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;

public class ErrorViewHolder
extends RecyclerView.ViewHolder {
    ErrorViewHolder(View itemView, Provider<AppConfig> appConfigProvider, final HomeClickListener clickListener) {
        super(itemView);
        TextView reloadButton = (TextView)itemView.findViewById(R.id.reload_button);
        reloadButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                clickListener.onReloadClicked();
            }
        });
        this.applyRetryButtonStyle(reloadButton, appConfigProvider.get());
    }

    private void applyRetryButtonStyle(TextView reloadButton, AppConfig appConfig) {
        Context context = reloadButton.getContext();
        int primaryColor = ColorUtils.primaryOrDarkColor(context, appConfig);
        FontUtils.setRobotoMediumTypeface(reloadButton);
        Drawable drawable2 = reloadButton.getBackground();
        BackgroundUtils.setRippleButtonStroke(context, drawable2, R.id.background, primaryColor);
        reloadButton.setTextColor(primaryColor);
    }
}

