/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;
import io.intercom.android.sdk.utilities.ViewUtils;

class TeammateProfileToolbarBehavior
extends ProfileToolbarBehavior {
    private static final float CHANGE_IN_AVATAR_SCALE = 0.85f;
    private static final float CHANGE_IN_ACTIVE_STATE_SCALE = 0.6f;
    private final float translate8dp;
    private final float translate28dp;
    private final float translate16dp;
    private final float profileTranslationY;
    private final float headerTextAlpha;
    private final ViewGroup rootLayout;
    @Nullable
    private View avatar1;
    @Nullable
    private View avatar2;
    @Nullable
    private View avatar3;
    @Nullable
    private View activeStateCircle;
    @Nullable
    private View title;
    @Nullable
    private View titleNameOnly;
    @Nullable
    private View subtitle;
    @Nullable
    private View role;
    @Nullable
    private View location;
    @Nullable
    private View bio;
    @Nullable
    private LinearLayout socialLayout;

    TeammateProfileToolbarBehavior(ViewGroup rootLayout) {
        super(rootLayout.getContext());
        this.rootLayout = rootLayout;
        Context context = rootLayout.getContext();
        this.translate8dp = ScreenUtils.dpToPx((float)8.0f, (Context)context);
        this.profileTranslationY = context.getResources().getDimensionPixelSize(R.dimen.intercom_team_profile_translation_y);
        this.translate28dp = ScreenUtils.dpToPx((float)28.0f, (Context)context);
        this.translate16dp = ScreenUtils.dpToPx((float)16.0f, (Context)context);
        TypedValue outValue = new TypedValue();
        context.getResources().getValue(R.dimen.intercom_header_text_alpha, outValue, true);
        this.headerTextAlpha = outValue.getFloat();
    }

    private void updateSocialButtons(ViewGroup child, View dependency) {
        if (this.socialLayout == null) {
            this.socialLayout = (LinearLayout)child.findViewById(R.id.social_button_layout);
        }
        this.translateY((View)this.socialLayout, dependency, this.profileTranslationY);
        this.setAlphaAsPercentageOfScroll((View)this.socialLayout, dependency, this.headerTextAlpha, false);
    }

    private void updateRole(ViewGroup child, View dependency) {
        if (this.role == null) {
            this.role = child.findViewById(R.id.intercom_collapsing_role_layout);
        }
        this.translateY(this.role, dependency, this.profileTranslationY);
        this.setAlphaAsPercentageOfScroll(this.role, dependency, 1.0f, false);
    }

    private void updateLocation(ViewGroup child, View dependency) {
        if (this.location == null) {
            this.location = child.findViewById(R.id.intercom_collapsing_location_layout);
        }
        this.translateY(this.location, dependency, this.profileTranslationY);
        this.setAlphaAsPercentageOfScroll(this.location, dependency, 1.0f, false);
    }

    private void updateBio(ViewGroup child, View dependency) {
        if (this.bio == null) {
            this.bio = child.findViewById(R.id.intercom_collapsing_bio_layout);
        }
        this.translateY(this.bio, dependency, this.profileTranslationY);
        this.setAlphaAsPercentageOfScroll(this.bio, dependency, 1.0f, false);
    }

    private void updateTitle(ViewGroup child, View dependency, float scrollPercentage) {
        float translationYTitleNameOnly;
        float newTranslationYTitleNameOnly;
        if (this.title == null) {
            this.title = child.findViewById(R.id.intercom_collapsing_title);
        }
        if (this.titleNameOnly == null) {
            this.titleNameOnly = child.findViewById(R.id.intercom_collapsing_title_name_only);
        }
        if (this.subtitle == null) {
            this.subtitle = child.findViewById(R.id.intercom_collapsing_subtitle);
        }
        this.setAlphaAsPercentageOfScroll(this.subtitle, dependency, this.headerTextAlpha, false);
        float translationYSubtitle = this.translate28dp / 100.0f * scrollPercentage;
        float newTransYSubtitle = (int)Math.max(0.0f, translationYSubtitle);
        if (newTransYSubtitle > 0.0f) {
            this.subtitle.setTranslationY(newTransYSubtitle);
        }
        if ((newTranslationYTitleNameOnly = (float)((int)Math.max(0.0f, translationYTitleNameOnly = this.translate16dp / 100.0f * scrollPercentage))) > 0.0f) {
            this.titleNameOnly.setTranslationY(newTranslationYTitleNameOnly);
            this.title.setTranslationY(newTranslationYTitleNameOnly);
        }
        this.setAlphaAsPercentageOfScroll(this.title, dependency, 1.0f, true);
        this.setAlphaAsPercentageOfScroll(this.titleNameOnly, dependency, 1.0f, false);
    }

    private void updateAvatar(ViewGroup child, View dependency, float scrollPercentage) {
        if (this.avatar1 == null) {
            this.avatar1 = child.findViewById(R.id.intercom_collapsing_teammate_avatar1);
        }
        if (this.avatar2 == null) {
            this.avatar2 = child.findViewById(R.id.intercom_collapsing_teammate_avatar2);
        }
        if (this.avatar3 == null) {
            this.avatar3 = child.findViewById(R.id.intercom_collapsing_teammate_avatar3);
        }
        if (this.activeStateCircle == null) {
            this.activeStateCircle = child.findViewById(R.id.intercom_collapsing_teammate_active_state);
        }
        Resources res = child.getContext().getResources();
        float avatarSize = res.getDimensionPixelSize(R.dimen.intercom_teammate_avatar_size);
        float activeStateSize = res.getDimensionPixelSize(R.dimen.intercom_teammate_active_state_size);
        float scaleRatio = 1.4166666f;
        float xFactor = 1.0f + (1.0f - activeStateSize / avatarSize) * scaleRatio;
        float yFactor = 1.0f + activeStateSize / avatarSize * scaleRatio;
        float translationX = this.translate8dp / 100.0f * scrollPercentage;
        this.avatar1.setTranslationX((float)((int)Math.max(translationX, 0.0f)));
        this.activeStateCircle.setTranslationX((float)((int)Math.max(translationX * xFactor, 0.0f)));
        float translationY = this.profileTranslationY / 100.0f * scrollPercentage;
        this.avatar1.setTranslationY((float)((int)Math.max(0.0f, translationY)));
        this.activeStateCircle.setTranslationY((float)((int)Math.max(0.0f, translationY * yFactor)));
        float scale = 1.0f + 0.0085f * scrollPercentage;
        float activeStateScale = 1.0f + 0.006f * scrollPercentage;
        this.avatar1.setScaleX(scale);
        this.avatar1.setScaleY(scale);
        this.activeStateCircle.setScaleX(activeStateScale);
        this.activeStateCircle.setScaleY(activeStateScale);
        this.setAlphaAsPercentageOfScroll(this.avatar2, dependency, 1.0f, true);
        this.setAlphaAsPercentageOfScroll(this.avatar3, dependency, 1.0f, true);
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
        if ((float)appBarLayout.getHeight() <= this.toolbarHeight) {
            return;
        }
        float scrollPercentage = this.getScrollPercentage((View)appBarLayout);
        this.rootLayout.getLayoutParams().height = appBarLayout.getBottom();
        this.updateAvatar(this.rootLayout, (View)appBarLayout, scrollPercentage);
        this.updateTitle(this.rootLayout, (View)appBarLayout, scrollPercentage);
        this.updateRole(this.rootLayout, (View)appBarLayout);
        this.updateLocation(this.rootLayout, (View)appBarLayout);
        this.updateBio(this.rootLayout, (View)appBarLayout);
        this.updateSocialButtons(this.rootLayout, (View)appBarLayout);
        ViewUtils.requestLayoutIfPossible((View)this.rootLayout);
    }

    private void translateY(View child, View dependency, float totalYTranslation) {
        float translation = totalYTranslation / 100.0f * this.getScrollPercentage(dependency);
        child.setTranslationY((float)((int)Math.max(0.0f, translation)));
    }
}

