/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.carousel;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.carousel.PermissionManager;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.models.carousel.CarouselScreen;
import io.intercom.android.sdk.models.carousel.ScreenAction;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import java.util.Iterator;
import java.util.List;

public class CarouselPresenter {
    private final Carousel carousel;
    private final Store<State> store;
    private final Api api;
    private final MetricTracker metricTracker;
    private final PermissionManager permissionManager;
    private final int initialNumberOfScreens;

    public CarouselPresenter(Store<State> store, Api api, MetricTracker metricTracker, PermissionManager permissionManager) {
        this.store = store;
        this.carousel = store.select(Selectors.OVERLAY).carousel();
        this.initialNumberOfScreens = this.carousel.getScreens().size();
        this.api = api;
        this.metricTracker = metricTracker;
        this.permissionManager = permissionManager;
        this.filterCarouselScreens(this.carousel);
    }

    public Carousel getCarousel() {
        return this.carousel;
    }

    public void resetPersistedCarousel() {
        this.store.dispatch(Actions.carouselDismissed());
    }

    public void recordDismissedOrCompletedStats(boolean isLastScreenViewed) {
        String instanceId = this.getCarousel().getInstanceId();
        if (isLastScreenViewed) {
            this.api.markCarouselAsCompleted(instanceId);
        } else {
            this.api.markCarouselAsDismissed(instanceId);
        }
    }

    public void recordScreenSeenStats(String screenId) {
        String instanceId = this.getCarousel().getInstanceId();
        this.api.markCarouselScreenViewed(instanceId, screenId);
    }

    public void recordActionButtonTappedStats(@NonNull String screenId) {
        String instanceId = this.getCarousel().getInstanceId();
        this.api.markCarouselActionButtonTapped(instanceId, screenId);
    }

    public void recordOpenMetric() {
        int numberOfScreensShown = this.getCarousel().getScreens().size();
        this.metricTracker.openedCarousel(this.getCarousel().getInstanceId(), this.initialNumberOfScreens, numberOfScreensShown);
    }

    public void recordDismissedOrCompletedMetric(String context, boolean isLastScreenViewed, int screensSeen) {
        int numberOfScreensShown = this.getCarousel().getScreens().size();
        String instanceId = this.getCarousel().getInstanceId();
        if (isLastScreenViewed) {
            this.metricTracker.completedCarousel(context, instanceId, this.initialNumberOfScreens, numberOfScreensShown);
        } else {
            this.metricTracker.dismissedCarousel(context, instanceId, this.initialNumberOfScreens, numberOfScreensShown, screensSeen);
        }
    }

    public void recordPermissionRequestedMetric(String permissionType, int[] grantResults, String screenId) {
        boolean isGranted = false;
        String instanceId = this.getCarousel().getInstanceId();
        for (int result : grantResults) {
            if (result != 0) continue;
            isGranted = true;
            this.api.markPermissionGranted(instanceId, screenId);
            break;
        }
        this.metricTracker.requestedPermission(permissionType, instanceId, isGranted);
    }

    public void recordSentToPermissionSettingsMetric(ScreenAction permissionAction, String screenId) {
        String permissionType = permissionAction.getType();
        List<String> permissions = permissionAction.getValidPermissions(this.permissionManager);
        boolean isGranted = this.permissionManager.permissionsGranted(permissions);
        String instanceId = this.getCarousel().getInstanceId();
        if (isGranted) {
            this.api.markPermissionGranted(instanceId, screenId);
        }
        this.metricTracker.sentToPermissionSettings(permissionType, instanceId, isGranted);
    }

    @VisibleForTesting
    void filterCarouselScreens(Carousel carousel) {
        Iterator<CarouselScreen> iterator = carousel.getScreens().iterator();
        while (iterator.hasNext()) {
            CarouselScreen screen = iterator.next();
            if (!this.screenShouldBeRemoved(screen)) continue;
            iterator.remove();
        }
    }

    @VisibleForTesting
    boolean screenShouldBeRemoved(CarouselScreen screen) {
        ScreenAction permissionAction = screen.getPermissionAction();
        if (ScreenAction.NULL.equals(permissionAction)) {
            return false;
        }
        List<String> permissionStrings = permissionAction.getValidPermissions(this.permissionManager);
        return Build.VERSION.SDK_INT < 23 || permissionStrings.isEmpty() || this.permissionManager.permissionsGranted(permissionStrings);
    }
}

