/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.facebook.shimmer;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.intercom.com.facebook.shimmer.R;
import io.intercom.com.facebook.shimmer.Shimmer;
import io.intercom.com.facebook.shimmer.ShimmerDrawable;

public class ShimmerFrameLayout
extends FrameLayout {
    private final Paint mContentPaint = new Paint();
    private final ShimmerDrawable mShimmerDrawable = new ShimmerDrawable();
    private boolean mShowShimmer = true;

    public ShimmerFrameLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public ShimmerFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ShimmerFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ShimmerFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.setWillNotDraw(false);
        this.mShimmerDrawable.setCallback((Drawable.Callback)this);
        if (attrs == null) {
            this.setShimmer(new Shimmer.AlphaHighlightBuilder().build());
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShimmerFrameLayout, 0, 0);
        try {
            Shimmer.AlphaHighlightBuilder shimmerBuilder = a.hasValue(R.styleable.ShimmerFrameLayout_shimmer_colored) && a.getBoolean(R.styleable.ShimmerFrameLayout_shimmer_colored, false) ? new Shimmer.ColorHighlightBuilder() : new Shimmer.AlphaHighlightBuilder();
            this.setShimmer(((Shimmer.Builder)shimmerBuilder.consumeAttributes(a)).build());
        }
        finally {
            a.recycle();
        }
    }

    public ShimmerFrameLayout setShimmer(@Nullable Shimmer shimmer) {
        this.mShimmerDrawable.setShimmer(shimmer);
        if (shimmer != null && shimmer.clipToChildren) {
            this.setLayerType(2, this.mContentPaint);
        } else {
            this.setLayerType(0, null);
        }
        return this;
    }

    public void startShimmer() {
        this.mShimmerDrawable.startShimmer();
    }

    public void stopShimmer() {
        this.mShimmerDrawable.stopShimmer();
    }

    public boolean isShimmerStarted() {
        return this.mShimmerDrawable.isShimmerStarted();
    }

    public void showShimmer(boolean startShimmer) {
        if (this.mShowShimmer) {
            return;
        }
        this.mShowShimmer = true;
        if (startShimmer) {
            this.startShimmer();
        }
    }

    public void hideShimmer() {
        if (!this.mShowShimmer) {
            return;
        }
        this.stopShimmer();
        this.mShowShimmer = false;
        this.invalidate();
    }

    public boolean isShimmerVisible() {
        return this.mShowShimmer;
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = this.getWidth();
        int height = this.getHeight();
        this.mShimmerDrawable.setBounds(0, 0, width, height);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mShimmerDrawable.maybeStartShimmer();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopShimmer();
    }

    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mShowShimmer) {
            this.mShimmerDrawable.draw(canvas);
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.mShimmerDrawable;
    }
}

