/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.AutoValue_Avatar;
import io.intercom.android.sdk.utilities.NullSafety;

@AutoValue
public abstract class Avatar
implements Parcelable {
    public static final Parcelable.Creator<Avatar> CREATOR = new Parcelable.Creator<Avatar>(){

        public Avatar createFromParcel(Parcel in) {
            String imageUrl = in.readString();
            String initials = in.readString();
            return Avatar.create(imageUrl, initials);
        }

        public Avatar[] newArray(int size) {
            return new Avatar[size];
        }
    };

    public static Avatar create(String imageUrl, String initials) {
        return new AutoValue_Avatar(imageUrl, initials);
    }

    public abstract String getImageUrl();

    public abstract String getInitials();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getImageUrl());
        dest.writeString(this.getInitials());
    }

    public static final class Builder {
        @Nullable
        String image_url;
        @Nullable
        String initials;

        Builder withInitials(String initials) {
            this.initials = initials;
            return this;
        }

        public Avatar build() {
            return Avatar.create(NullSafety.valueOrEmpty(this.image_url), NullSafety.valueOrEmpty(this.initials));
        }
    }
}

