/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.ContentResolver;
import android.net.Uri;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.okhttp3.MediaType;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okhttp3.internal.Util;
import io.intercom.okio.BufferedSink;
import io.intercom.okio.Okio;
import io.intercom.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

class ProgressRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    private final MediaType contentType;
    private final GalleryImage image;
    private final ContentResolver contentResolver;
    private final UploadProgressListener listener;

    public ProgressRequestBody(MediaType contentType, GalleryImage image, ContentResolver contentResolver, UploadProgressListener listener) {
        this.contentType = contentType;
        this.image = image;
        this.contentResolver = contentResolver;
        this.listener = listener;
    }

    public long contentLength() {
        return this.image.getFileSize();
    }

    public MediaType contentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        Uri uri = this.image.getUri();
        if (uri != Uri.EMPTY) {
            Source source = null;
            try {
                long read;
                InputStream in = this.contentResolver.openInputStream(uri);
                source = Okio.source((InputStream)in);
                long total = 0L;
                while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                    sink.flush();
                    this.listener.uploadNotice((byte)((double)((total += read) * 100L / (long)this.image.getFileSize()) * 0.8 + 10.0));
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(source);
                throw throwable;
            }
            Util.closeQuietly((Closeable)source);
        }
    }
}

