/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.transition.ChangeBounds;
import android.transition.Transition;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.LightboxOpeningImageClickListener;
import io.intercom.android.sdk.blocks.LinkOpeningButtonClickListener;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.conversation.ReactionListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Link;
import io.intercom.android.sdk.models.LinkResponse;
import io.intercom.android.sdk.models.Reaction;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.views.ContentAwareScrollView;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.RequestManager;

public class IntercomArticleActivity
extends IntercomBaseActivity {
    public static final String LINK_TRANSITION_KEY = "link_background";
    private static final String PARCEL_LINK_ID = "parcel_link_id";
    private static final String PARCEL_PART_ID = "parcel_part_id";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final int ENTRANCE_ANIMATION_TIME_MS = 300;
    private static final int EXIT_ANIMATION_TIME_MS = 150;
    Api api;
    String conversationId = "";
    private String partId = "";
    String linkId = "";
    private BlocksViewHolder articleHolder;
    private int avatarSize;
    int titleSize = 0;
    boolean titleBarEnabled = false;
    private TextView title;
    private TextView description;
    private TextView author;
    private TextView updated;
    private ImageView avatar;
    private TimeFormatter timeFormatter;
    ContentAwareScrollView scrollView;
    private ReactionInputView reactionComposer;
    FrameLayout linkView;
    private View composerLayout;
    private LinearLayout linkContainer;
    FrameLayout titleBar;
    TextView titleBarText;
    ProgressBar loadingView;
    private IntercomErrorView intercomErrorView;
    MetricTracker metricTracker;
    private Provider<AppConfig> appConfigProvider;
    private RequestManager requestManager;
    private final BaseCallback<LinkResponse.Builder> apiCallback = new BaseCallback<LinkResponse.Builder>(){

        @Override
        protected void onSuccess(LinkResponse.Builder builder) {
            IntercomArticleActivity.this.scrollView.setVisibility(0);
            IntercomArticleActivity.this.loadingView.setVisibility(8);
            IntercomArticleActivity.this.intercomErrorView.setVisibility(8);
            IntercomArticleActivity.this.updateContent(builder.build().getLink());
            IntercomArticleActivity.this.metricTracker.viewedArticle(IntercomArticleActivity.this.conversationId, IntercomArticleActivity.this.linkId);
        }

        @Override
        protected void onError(ErrorObject errorDetails) {
            IntercomArticleActivity.this.intercomErrorView.setVisibility(0);
            IntercomArticleActivity.this.loadingView.setVisibility(8);
            IntercomArticleActivity.this.scrollView.setVisibility(8);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_article);
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            this.conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
            this.partId = data.getString(PARCEL_PART_ID, "");
            this.linkId = data.getString(PARCEL_LINK_ID, "");
        }
        this.requestManager = Glide.with((FragmentActivity)this);
        Injector injector = Injector.get();
        this.appConfigProvider = injector.getAppConfigProvider();
        this.api = injector.getApi();
        this.api.getLink(this.linkId, this.apiCallback);
        this.metricTracker = injector.getMetricTracker();
        int primaryColor = ColorUtils.primaryOrDarkColor((Context)this, this.appConfigProvider.get());
        this.timeFormatter = new TimeFormatter((Context)this, injector.getTimeProvider());
        this.linkView = (FrameLayout)this.findViewById(R.id.link_view);
        this.titleBar = (FrameLayout)this.findViewById(R.id.link_title_bar);
        this.titleBarText = (TextView)this.findViewById(R.id.title_bar_text);
        this.titleBarText.setTextColor(primaryColor);
        this.loadingView = (ProgressBar)this.findViewById(R.id.loading_view);
        this.title = (TextView)this.findViewById(R.id.title);
        this.title.setTextColor(primaryColor);
        this.description = (TextView)this.findViewById(R.id.description);
        this.reactionComposer = (ReactionInputView)this.findViewById(R.id.reaction_input_view);
        this.composerLayout = this.findViewById(R.id.link_composer_container);
        this.author = (TextView)this.findViewById(R.id.author);
        this.updated = (TextView)this.findViewById(R.id.updated);
        this.avatarSize = this.getResources().getDimensionPixelSize(R.dimen.intercom_avatar_size);
        this.avatar = (ImageView)this.findViewById(R.id.avatar_view);
        ViewHolderGenerator viewHolderGenerator = new ViewHolderGenerator(new UploadingImageCache(), this.api, this.appConfigProvider, this.conversationId, new LightboxOpeningImageClickListener(this.api), new LinkOpeningButtonClickListener(this.api), this.requestManager, injector.getGson(), injector.getBus(), this.metricTracker, (Activity)this);
        this.articleHolder = viewHolderGenerator.getArticleHolder();
        this.intercomErrorView = (IntercomErrorView)this.findViewById(R.id.error_layout_article);
        this.intercomErrorView.setActionButtonTextColor(primaryColor);
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntercomArticleActivity.this.loadingView.setVisibility(0);
                IntercomArticleActivity.this.api.getLink(IntercomArticleActivity.this.linkId, IntercomArticleActivity.this.apiCallback);
            }
        });
        this.linkContainer = (LinearLayout)this.findViewById(R.id.link_container);
        this.scrollView = (ContentAwareScrollView)this.findViewById(R.id.scroll_view);
        this.findViewById(R.id.dismiss).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntercomArticleActivity.this.metricTracker.closedArticle(IntercomArticleActivity.this.conversationId, IntercomArticleActivity.this.linkId, 0);
                IntercomArticleActivity.this.closeLink();
            }
        });
        this.getWindow().setSharedElementEnterTransition(this.enterTransition());
        this.getWindow().setSharedElementReturnTransition(this.returnTransition());
        this.findViewById(R.id.link_view).setTransitionName(LINK_TRANSITION_KEY);
    }

    private void updateContent(final Link link) {
        Avatar authorAvatar = Avatar.create(link.getAuthor().getAvatar(), "");
        AvatarUtils.createAvatar(authorAvatar, this.avatar, this.avatarSize, this.appConfigProvider.get(), this.requestManager);
        String descriptionText = link.getDescription();
        if (TextUtils.isEmpty((CharSequence)descriptionText)) {
            this.description.setVisibility(8);
        } else {
            this.description.setVisibility(0);
            this.description.setText((CharSequence)descriptionText);
        }
        String titleText = link.getTitle();
        this.title.setText((CharSequence)titleText);
        this.titleBarText.setText((CharSequence)titleText);
        this.setAuthorSpannable(link.getAuthor().getFirstName());
        this.updated.setText(this.timeFormatter.getUpdated(link.getUpdatedAt()));
        LinearLayout partsView = ViewHolderGenerator.createLayoutFromBlocks(this.articleHolder, link.getBlocks(), (Context)this);
        this.linkContainer.addView(BlockUtils.getBlockView((ViewGroup)this.linkContainer, partsView, (Context)this));
        this.titleSize = this.title.getMeasuredHeight();
        this.scrollView.setListener(new ContentAwareScrollView.Listener(){

            @Override
            public void onBottomReached() {
            }

            @Override
            public void onScrollChanged(int currentScroll) {
                if (IntercomArticleActivity.this.titleBarEnabled) {
                    IntercomArticleActivity.this.titleBar.setAlpha((float)(currentScroll -= IntercomArticleActivity.this.titleSize) / 100.0f);
                    IntercomArticleActivity.this.titleBarText.setAlpha((float)(currentScroll - IntercomArticleActivity.this.titleBar.getHeight()) / 100.0f);
                }
            }
        });
        this.scrollView.setAlpha(0.0f);
        this.scrollView.animate().alpha(1.0f).setDuration(300L).start();
        if (!ReactionReply.isNull(link.getReactionReply())) {
            ReactionReply linkReply = link.getReactionReply();
            int reactionHeight = this.getResources().getDimensionPixelSize(R.dimen.intercom_link_reaction_height);
            this.scrollView.setPadding(this.scrollView.getPaddingLeft(), this.scrollView.getPaddingTop(), this.scrollView.getPaddingRight(), reactionHeight);
            this.reactionComposer.preloadReactionImages(linkReply, this.requestManager);
            this.reactionComposer.setUpReactions(linkReply, false, new ReactionListener(){

                @Override
                public void onReactionSelected(Reaction reaction) {
                    Injector.get().getApi().reactToLink(link.getId(), null, reaction.getIndex(), false);
                    IntercomArticleActivity.this.metricTracker.sentReaction(IntercomArticleActivity.this.conversationId, IntercomArticleActivity.this.partId, reaction.getIndex(), MetricTracker.ReactionLocation.LINK);
                    ((TextView)IntercomArticleActivity.this.findViewById(R.id.reaction_text)).setText(R.string.intercom_article_response);
                }
            }, this.requestManager);
            this.composerLayout.setVisibility(0);
            this.composerLayout.setY(this.composerLayout.getY() + (float)reactionHeight);
            this.composerLayout.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).translationY(0.0f).setDuration(300L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    IntercomArticleActivity.this.linkView.setClipChildren(false);
                }
            }).start();
            Integer selectedIndex = linkReply.getReactionIndex();
            if (selectedIndex != null) {
                ((TextView)this.findViewById(R.id.reaction_text)).setText(R.string.intercom_article_response);
            }
        }
        ViewTreeObserver viewTreeObs = this.scrollView.getViewTreeObserver();
        viewTreeObs.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewUtils.removeGlobalLayoutListener((View)IntercomArticleActivity.this.scrollView, this);
                float linkViewHeight = (float)IntercomArticleActivity.this.linkView.getMeasuredHeight() * 1.5f;
                int scrollHeight = IntercomArticleActivity.this.scrollView.getChildAt(0).getMeasuredHeight();
                if ((float)scrollHeight > linkViewHeight) {
                    IntercomArticleActivity.this.titleBarEnabled = true;
                }
            }
        });
    }

    private void setAuthorSpannable(String firstName) {
        SpannableStringBuilder spannableAuthorName = new SpannableStringBuilder((CharSequence)("Written by " + firstName));
        int nameEnd = spannableAuthorName.length();
        int nameStart = nameEnd - firstName.length();
        spannableAuthorName.setSpan((Object)new StyleSpan(1), nameStart, nameEnd, 33);
        this.author.setText((CharSequence)spannableAuthorName);
    }

    void closeLink() {
        this.titleBarEnabled = false;
        this.fadeOutView((View)this.scrollView);
        this.fadeOutView(this.composerLayout);
        this.fadeOutView((View)this.titleBar);
        this.supportFinishAfterTransition();
    }

    private void fadeOutView(View view) {
        view.animate().alpha(0.0f).setDuration(150L).start();
    }

    public void onBackPressed() {
        this.metricTracker.closedArticle(this.conversationId, this.linkId, 1);
        this.closeLink();
    }

    public static Intent buildIntent(Context context, String linkId, String conversationId) {
        return IntercomArticleActivity.buildIntent(context, linkId, null, conversationId);
    }

    public static Intent buildIntent(Context context, String linkId, @Nullable String partId, String conversationId) {
        Intent intent = new Intent(context, IntercomArticleActivity.class);
        intent.putExtra(PARCEL_LINK_ID, linkId);
        if (partId != null) {
            intent.putExtra(PARCEL_PART_ID, partId);
        }
        intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        intent.setFlags(0x10000000);
        return intent;
    }

    private Transition enterTransition() {
        ChangeBounds bounds = new ChangeBounds();
        bounds.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        bounds.setDuration(300L);
        return bounds;
    }

    @TargetApi(value=19)
    private Transition returnTransition() {
        ChangeBounds bounds = new ChangeBounds();
        bounds.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        bounds.setDuration(150L);
        return bounds;
    }
}

