/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.push.SystemNotificationFactory;
import io.intercom.android.sdk.twig.Twig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SystemNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;
    @VisibleForTesting
    final List<PushPayload> receivedPayloads = Collections.synchronizedList(new ArrayList());
    private final Twig twig = LumberMill.getLogger();
    private final SystemNotificationFactory systemNotificationFactory;
    private final NotificationManager androidNotificationManager;
    static final String CHAT_REPLIES_CHANNEL = "intercom_chat_replies_channel";
    static final String NEW_CHATS_CHANNEL = "intercom_new_chats_channel";
    static final String ACTIONS_CHANNEL = "intercom_actions_channel";

    public SystemNotificationManager(NotificationManager androidNotificationManager) {
        this(androidNotificationManager, new SystemNotificationFactory());
    }

    @VisibleForTesting
    SystemNotificationManager(NotificationManager androidNotificationManager, SystemNotificationFactory systemNotificationFactory) {
        this.androidNotificationManager = androidNotificationManager;
        this.systemNotificationFactory = systemNotificationFactory;
    }

    public void setUpNotificationChannelsIfSupported(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.setUpNotificationChannels(context);
        }
    }

    public void deleteNotificationChannels() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.androidNotificationManager.deleteNotificationChannel(CHAT_REPLIES_CHANNEL);
            this.androidNotificationManager.deleteNotificationChannel(NEW_CHATS_CHANNEL);
            this.androidNotificationManager.deleteNotificationChannel(ACTIONS_CHANNEL);
        }
    }

    @TargetApi(value=26)
    private void setUpNotificationChannels(Context context) {
        NotificationChannel replies = new NotificationChannel(CHAT_REPLIES_CHANNEL, (CharSequence)context.getString(R.string.intercom_notification_channel_chat_replies_title), 4);
        replies.setDescription(context.getString(R.string.intercom_notification_channel_chat_replies_description));
        NotificationChannel newChats = new NotificationChannel(NEW_CHATS_CHANNEL, (CharSequence)context.getString(R.string.intercom_notification_channel_new_chats_title), 4);
        newChats.setDescription(context.getString(R.string.intercom_notification_channel_new_chats_description));
        NotificationChannel actions = new NotificationChannel(ACTIONS_CHANNEL, (CharSequence)context.getString(R.string.intercom_notification_channel_actions_title), 4);
        actions.setDescription(context.getString(R.string.intercom_notification_channel_actions_description));
        this.androidNotificationManager.createNotificationChannels(Arrays.asList(replies, newChats, actions));
    }

    public void clear() {
        if (!this.receivedPayloads.isEmpty()) {
            this.twig.i("Removing Intercom push notifications.", new Object[0]);
        }
        this.androidNotificationManager.cancel(9999997);
        this.receivedPayloads.clear();
    }

    void createPushOnlyNotification(PushPayload payload, Context context, AppConfig appConfig) {
        Notification notification = this.systemNotificationFactory.createPushOnlyNotification(payload, context, appConfig);
        String pushOnlyConversationId = payload.getPushOnlyConversationId();
        this.androidNotificationManager.notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), notification);
    }

    void createNotification(PushPayload payload, Context context, AppConfig appConfig) {
        if (this.receivedPayloads.contains(payload)) {
            return;
        }
        this.receivedPayloads.add(payload);
        Notification notification = this.receivedPayloads.size() == 1 ? this.systemNotificationFactory.createSingleNotification(payload, context, appConfig) : this.systemNotificationFactory.createGroupedNotification(this.receivedPayloads, context, appConfig);
        this.androidNotificationManager.notify(9999997, notification);
    }
}

