/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.models.ComposerState;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.OperatorClientCondition;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Conversation {
    private final Map<String, Participant> participants;
    private final List<Part> conversationParts;
    private final List<Participant> groupConversationParticipants;
    private final List<OperatorClientCondition> operatorClientConditions;
    private final LastParticipatingAdmin lastParticipatingAdmin;
    private final ComposerState composerState;
    private final String id;
    private final boolean userParticipated;
    private final boolean read;
    private final String intercomLinkSolution;

    public Conversation() {
        this(new Builder());
    }

    Conversation(Builder builder) {
        this.id = NullSafety.valueOrEmpty(builder.id);
        this.read = builder.read;
        this.userParticipated = builder.user_participated;
        this.participants = new LinkedHashMap<String, Participant>();
        this.intercomLinkSolution = NullSafety.valueOrEmpty(builder.intercom_link_solution);
        if (builder.participants != null) {
            for (Participant.Builder participantBuilder : builder.participants) {
                Participant participant = participantBuilder.build();
                this.participants.put(participant.getId(), participant);
            }
        }
        this.conversationParts = new ArrayList<Part>();
        if (builder.conversation_parts != null) {
            for (Part.Builder partBuilder : builder.conversation_parts) {
                Part part = partBuilder.build();
                part.setParticipant(this.getParticipant(part.getParticipantId()));
                this.conversationParts.add(part);
            }
        }
        this.groupConversationParticipants = new ArrayList<Participant>();
        if (builder.group_conversation_participant_ids != null) {
            for (String participantId : builder.group_conversation_participant_ids) {
                if (participantId == null) continue;
                this.groupConversationParticipants.add(this.getParticipant(participantId));
            }
        }
        this.operatorClientConditions = new ArrayList<OperatorClientCondition>();
        if (builder.operator_client_conditions != null) {
            for (OperatorClientCondition.Builder clientCondition : builder.operator_client_conditions) {
                if (clientCondition == null) continue;
                this.operatorClientConditions.add(clientCondition.build());
            }
        }
        this.lastParticipatingAdmin = builder.last_participating_admin != null ? builder.last_participating_admin.build() : LastParticipatingAdmin.NULL;
        this.composerState = builder.composer_state != null ? builder.composer_state.build() : ComposerState.NULL;
    }

    private Conversation(Map<String, Participant> participants, List<Part> conversationParts, List<Participant> groupConversationParticipantIds, List<OperatorClientCondition> operatorClientConditions, LastParticipatingAdmin lastParticipatingAdmin, ComposerState composerState, String id2, boolean userParticipated, boolean read, String intercomLinkSolution) {
        this.participants = participants;
        this.conversationParts = conversationParts;
        this.groupConversationParticipants = groupConversationParticipantIds;
        this.operatorClientConditions = operatorClientConditions;
        this.lastParticipatingAdmin = lastParticipatingAdmin;
        this.composerState = composerState;
        this.id = id2;
        this.userParticipated = userParticipated;
        this.read = read;
        this.intercomLinkSolution = intercomLinkSolution;
    }

    public List<Part> getParts() {
        return this.conversationParts;
    }

    public Part getLastPart() {
        return this.conversationParts.isEmpty() ? Part.NULL : this.conversationParts.get(this.conversationParts.size() - 1);
    }

    public Part getLastNonEventPart() {
        for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
            Part part = this.conversationParts.get(i);
            if (part.isEvent().booleanValue()) continue;
            return part;
        }
        return Part.NULL;
    }

    public Part getLastAdminPart() {
        for (int i = this.conversationParts.size() - 1; i >= 0; --i) {
            Part part = this.conversationParts.get(i);
            if (!part.isAdmin()) continue;
            return part;
        }
        return Part.NULL;
    }

    public Participant getParticipant(String id2) {
        Participant participant = this.participants.get(id2);
        if (participant == null) {
            participant = Participant.NULL;
        }
        return participant;
    }

    public List<Participant> getGroupConversationParticipants() {
        return this.groupConversationParticipants;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isUserParticipated() {
        return this.userParticipated;
    }

    public String getIntercomLinkSolution() {
        return this.intercomLinkSolution;
    }

    public List<OperatorClientCondition> getOperatorClientConditions() {
        return this.operatorClientConditions;
    }

    public Participant getLastAdmin() {
        ListIterator<Participant> iterator = new ArrayList<Participant>(this.participants.values()).listIterator(this.participants.values().size());
        while (iterator.hasPrevious()) {
            Participant participant = iterator.previous();
            if (!participant.isAdmin()) continue;
            return participant;
        }
        return Participant.NULL;
    }

    public Map<String, Participant> getParticipants() {
        return this.participants;
    }

    public LastParticipatingAdmin getLastParticipatingAdmin() {
        return this.lastParticipatingAdmin;
    }

    public ComposerState getComposerState() {
        return this.composerState;
    }

    public boolean isAdminReply() {
        return this.participants.size() > 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation that = (Conversation)o;
        if (this.userParticipated != that.userParticipated) {
            return false;
        }
        if (this.read != that.read) {
            return false;
        }
        if (!this.participants.equals(that.participants)) {
            return false;
        }
        if (!this.conversationParts.equals(that.conversationParts)) {
            return false;
        }
        if (!this.groupConversationParticipants.equals(that.groupConversationParticipants)) {
            return false;
        }
        if (!this.operatorClientConditions.equals(that.operatorClientConditions)) {
            return false;
        }
        if (!this.lastParticipatingAdmin.equals(that.lastParticipatingAdmin)) {
            return false;
        }
        if (!this.composerState.equals(that.composerState)) {
            return false;
        }
        if (!this.intercomLinkSolution.equals(that.intercomLinkSolution)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.participants.hashCode();
        result = 31 * result + this.conversationParts.hashCode();
        result = 31 * result + this.groupConversationParticipants.hashCode();
        result = 31 * result + this.operatorClientConditions.hashCode();
        result = 31 * result + this.lastParticipatingAdmin.hashCode();
        result = 31 * result + this.composerState.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.userParticipated ? 1 : 0);
        result = 31 * result + (this.read ? 1 : 0);
        result = 31 * result + this.intercomLinkSolution.hashCode();
        return result;
    }

    public Conversation withRead(boolean read) {
        return new Conversation(this.participants, this.conversationParts, this.groupConversationParticipants, this.operatorClientConditions, this.lastParticipatingAdmin, this.composerState, this.id, this.userParticipated, read, this.intercomLinkSolution);
    }

    public static final class Builder {
        String id;
        boolean read;
        List<Participant.Builder> participants;
        List<Part.Builder> conversation_parts;
        List<String> group_conversation_participant_ids;
        List<OperatorClientCondition.Builder> operator_client_conditions;
        LastParticipatingAdmin.Builder last_participating_admin;
        ComposerState.Builder composer_state;
        boolean user_participated;
        String intercom_link_solution;

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withParticipants(List<Participant.Builder> participants) {
            this.participants = participants;
            return this;
        }

        public Builder withParts(List<Part.Builder> parts) {
            this.conversation_parts = parts;
            return this;
        }

        public Conversation build() {
            return new Conversation(this);
        }
    }
}

