/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.gif;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.RequestBuilder;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.gifdecoder.GifDecoder;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.SimpleTarget;
import io.intercom.com.bumptech.glide.request.transition.Transition;
import io.intercom.com.bumptech.glide.signature.ObjectKey;
import io.intercom.com.bumptech.glide.util.Preconditions;
import io.intercom.com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class GifFrameLoader {
    private final GifDecoder gifDecoder;
    private final Handler handler;
    private final List<FrameCallback> callbacks = new ArrayList<FrameCallback>();
    final RequestManager requestManager;
    private final BitmapPool bitmapPool;
    private boolean isRunning = false;
    private boolean isLoadPending = false;
    private boolean startFromFirstFrame = false;
    private RequestBuilder<Bitmap> requestBuilder;
    private DelayTarget current;
    private boolean isCleared;
    private DelayTarget next;
    private Bitmap firstFrame;
    private Transformation<Bitmap> transformation;
    private DelayTarget pendingTarget;
    @Nullable
    private OnEveryFrameListener onEveryFrameListener;

    GifFrameLoader(Glide glide, GifDecoder gifDecoder, int width, int height, Transformation<Bitmap> transformation, Bitmap firstFrame) {
        this(glide.getBitmapPool(), Glide.with(glide.getContext()), gifDecoder, null, GifFrameLoader.getRequestBuilder(Glide.with(glide.getContext()), width, height), transformation, firstFrame);
    }

    GifFrameLoader(BitmapPool bitmapPool, RequestManager requestManager, GifDecoder gifDecoder, Handler handler, RequestBuilder<Bitmap> requestBuilder, Transformation<Bitmap> transformation, Bitmap firstFrame) {
        this.requestManager = requestManager;
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new FrameLoaderCallback());
        }
        this.bitmapPool = bitmapPool;
        this.handler = handler;
        this.requestBuilder = requestBuilder;
        this.gifDecoder = gifDecoder;
        this.setFrameTransformation(transformation, firstFrame);
    }

    void setFrameTransformation(Transformation<Bitmap> transformation, Bitmap firstFrame) {
        this.transformation = Preconditions.checkNotNull(transformation);
        this.firstFrame = Preconditions.checkNotNull(firstFrame);
        this.requestBuilder = this.requestBuilder.apply(new RequestOptions().transform(transformation));
    }

    Transformation<Bitmap> getFrameTransformation() {
        return this.transformation;
    }

    Bitmap getFirstFrame() {
        return this.firstFrame;
    }

    void subscribe(FrameCallback frameCallback) {
        if (this.isCleared) {
            throw new IllegalStateException("Cannot subscribe to a cleared frame loader");
        }
        boolean start = this.callbacks.isEmpty();
        if (this.callbacks.contains(frameCallback)) {
            throw new IllegalStateException("Cannot subscribe twice in a row");
        }
        this.callbacks.add(frameCallback);
        if (start) {
            this.start();
        }
    }

    void unsubscribe(FrameCallback frameCallback) {
        this.callbacks.remove(frameCallback);
        if (this.callbacks.isEmpty()) {
            this.stop();
        }
    }

    int getWidth() {
        return this.getCurrentFrame().getWidth();
    }

    int getHeight() {
        return this.getCurrentFrame().getHeight();
    }

    int getSize() {
        return this.gifDecoder.getByteSize() + this.getFrameSize();
    }

    int getCurrentIndex() {
        return this.current != null ? this.current.index : -1;
    }

    private int getFrameSize() {
        return Util.getBitmapByteSize(this.getCurrentFrame().getWidth(), this.getCurrentFrame().getHeight(), this.getCurrentFrame().getConfig());
    }

    ByteBuffer getBuffer() {
        return this.gifDecoder.getData().asReadOnlyBuffer();
    }

    int getFrameCount() {
        return this.gifDecoder.getFrameCount();
    }

    int getLoopCount() {
        return this.gifDecoder.getTotalIterationCount();
    }

    private void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.isCleared = false;
        this.loadNextFrame();
    }

    private void stop() {
        this.isRunning = false;
    }

    void clear() {
        this.callbacks.clear();
        this.recycleFirstFrame();
        this.stop();
        if (this.current != null) {
            this.requestManager.clear(this.current);
            this.current = null;
        }
        if (this.next != null) {
            this.requestManager.clear(this.next);
            this.next = null;
        }
        if (this.pendingTarget != null) {
            this.requestManager.clear(this.pendingTarget);
            this.pendingTarget = null;
        }
        this.gifDecoder.clear();
        this.isCleared = true;
    }

    Bitmap getCurrentFrame() {
        return this.current != null ? this.current.getResource() : this.firstFrame;
    }

    private void loadNextFrame() {
        if (!this.isRunning || this.isLoadPending) {
            return;
        }
        if (this.startFromFirstFrame) {
            Preconditions.checkArgument(this.pendingTarget == null, "Pending target must be null when starting from the first frame");
            this.gifDecoder.resetFrameIndex();
            this.startFromFirstFrame = false;
        }
        if (this.pendingTarget != null) {
            DelayTarget temp = this.pendingTarget;
            this.pendingTarget = null;
            this.onFrameReady(temp);
            return;
        }
        this.isLoadPending = true;
        int delay = this.gifDecoder.getNextDelay();
        long targetTime = SystemClock.uptimeMillis() + (long)delay;
        this.gifDecoder.advance();
        this.next = new DelayTarget(this.handler, this.gifDecoder.getCurrentFrameIndex(), targetTime);
        ((RequestBuilder)this.requestBuilder.apply(RequestOptions.signatureOf(GifFrameLoader.getFrameSignature())).load(this.gifDecoder)).into(this.next);
    }

    private void recycleFirstFrame() {
        if (this.firstFrame != null) {
            this.bitmapPool.put(this.firstFrame);
            this.firstFrame = null;
        }
    }

    void setNextStartFromFirstFrame() {
        Preconditions.checkArgument(!this.isRunning, "Can't restart a running animation");
        this.startFromFirstFrame = true;
        if (this.pendingTarget != null) {
            this.requestManager.clear(this.pendingTarget);
            this.pendingTarget = null;
        }
    }

    @VisibleForTesting
    void setOnEveryFrameReadyListener(@Nullable OnEveryFrameListener onEveryFrameListener) {
        this.onEveryFrameListener = onEveryFrameListener;
    }

    @VisibleForTesting
    void onFrameReady(DelayTarget delayTarget) {
        if (this.onEveryFrameListener != null) {
            this.onEveryFrameListener.onFrameReady();
        }
        this.isLoadPending = false;
        if (this.isCleared) {
            this.handler.obtainMessage(2, (Object)delayTarget).sendToTarget();
            return;
        }
        if (!this.isRunning) {
            this.pendingTarget = delayTarget;
            return;
        }
        if (delayTarget.getResource() != null) {
            this.recycleFirstFrame();
            DelayTarget previous = this.current;
            this.current = delayTarget;
            for (int i = this.callbacks.size() - 1; i >= 0; --i) {
                FrameCallback cb = this.callbacks.get(i);
                cb.onFrameReady();
            }
            if (previous != null) {
                this.handler.obtainMessage(2, (Object)previous).sendToTarget();
            }
        }
        this.loadNextFrame();
    }

    private static RequestBuilder<Bitmap> getRequestBuilder(RequestManager requestManager, int width, int height) {
        return requestManager.asBitmap().apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.NONE).useAnimationPool(true).skipMemoryCache(true).override(width, height));
    }

    private static Key getFrameSignature() {
        return new ObjectKey(Math.random());
    }

    @VisibleForTesting
    static interface OnEveryFrameListener {
        public void onFrameReady();
    }

    @VisibleForTesting
    static class DelayTarget
    extends SimpleTarget<Bitmap> {
        private final Handler handler;
        final int index;
        private final long targetTime;
        private Bitmap resource;

        DelayTarget(Handler handler, int index, long targetTime) {
            this.handler = handler;
            this.index = index;
            this.targetTime = targetTime;
        }

        Bitmap getResource() {
            return this.resource;
        }

        @Override
        public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
            this.resource = resource;
            Message msg = this.handler.obtainMessage(1, (Object)this);
            this.handler.sendMessageAtTime(msg, this.targetTime);
        }
    }

    private class FrameLoaderCallback
    implements Handler.Callback {
        static final int MSG_DELAY = 1;
        static final int MSG_CLEAR = 2;

        FrameLoaderCallback() {
        }

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                DelayTarget target = (DelayTarget)msg.obj;
                GifFrameLoader.this.onFrameReady(target);
                return true;
            }
            if (msg.what == 2) {
                DelayTarget target = (DelayTarget)msg.obj;
                GifFrameLoader.this.requestManager.clear(target);
            }
            return false;
        }
    }

    public static interface FrameCallback {
        public void onFrameReady();
    }
}

