/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.drawable;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.content.res.AppCompatResources;

public final class DrawableDecoderCompat {
    private static volatile boolean shouldCallAppCompatResources = true;

    private DrawableDecoderCompat() {
    }

    public static Drawable getDrawable(Context context, @DrawableRes int id2) {
        return DrawableDecoderCompat.getDrawable(context, id2, null);
    }

    public static Drawable getDrawable(Context context, @DrawableRes int id2, @Nullable Resources.Theme theme) {
        try {
            if (shouldCallAppCompatResources) {
                return DrawableDecoderCompat.loadDrawableV7(context, id2);
            }
        }
        catch (NoClassDefFoundError error) {
            shouldCallAppCompatResources = false;
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return DrawableDecoderCompat.loadDrawableV4(context, id2, theme != null ? theme : context.getTheme());
    }

    private static Drawable loadDrawableV7(Context context, @DrawableRes int id2) {
        return AppCompatResources.getDrawable((Context)context, (int)id2);
    }

    private static Drawable loadDrawableV4(Context context, @DrawableRes int id2, @Nullable Resources.Theme theme) {
        Resources resources = context.getResources();
        return ResourcesCompat.getDrawable((Resources)resources, (int)id2, (Resources.Theme)theme);
    }
}

