/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import io.intercom.android.sdk.R;

public class AttributeCollectorCardView
extends LinearLayout {
    private static final long ANIMATE_DURATION = 400L;
    @Px
    private final int originalPadding;
    @Px
    private final int originalLeftMargin;
    @Px
    private final int expandedLeftMargin;
    @Px
    private final int expandedPadding;
    @Px
    private final int originalShadowSize;
    @Px
    private final int expandedShadowSize;
    @Px
    private final int originalBottomMargin;
    @Px
    private final int shadowSizeDiff;
    private ValueAnimator.AnimatorUpdateListener widthAnimateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)AttributeCollectorCardView.this.getLayoutParams();
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)((Integer)animation.getAnimatedValue()));
            AttributeCollectorCardView.this.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    };
    private ValueAnimator.AnimatorUpdateListener heightAnimateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int verticalPadding = (Integer)animation.getAnimatedValue();
            int horizontalPadding = AttributeCollectorCardView.this.originalPadding;
            AttributeCollectorCardView.this.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        }
    };
    private ValueAnimator.AnimatorUpdateListener shadowAnimateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            if (Build.VERSION.SDK_INT >= 21) {
                AttributeCollectorCardView.this.setElevation(((Integer)animation.getAnimatedValue()).intValue());
            }
        }
    };
    private ValueAnimator.AnimatorUpdateListener verticalMarginAnimateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int verticalMarginValue;
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)AttributeCollectorCardView.this.getLayoutParams();
            params.topMargin = verticalMarginValue = ((Integer)animation.getAnimatedValue()).intValue();
            params.bottomMargin = verticalMarginValue + AttributeCollectorCardView.this.originalBottomMargin;
            AttributeCollectorCardView.this.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    };

    public AttributeCollectorCardView(Context context) {
        this(context, null);
    }

    public AttributeCollectorCardView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        Resources resources = context.getResources();
        this.originalPadding = resources.getDimensionPixelSize(R.dimen.intercom_container_cell_padding);
        this.originalLeftMargin = resources.getDimensionPixelSize(R.dimen.intercom_attribute_part_left_margin);
        this.expandedLeftMargin = resources.getDimensionPixelSize(R.dimen.intercom_cell_horizontal_padding);
        this.expandedPadding = resources.getDimensionPixelSize(R.dimen.intercom_attribute_part_expanded_vertical_padding);
        this.originalShadowSize = resources.getDimensionPixelSize(R.dimen.intercom_card_shadow_size);
        this.expandedShadowSize = resources.getDimensionPixelSize(R.dimen.intercom_attribute_card_expanded_shadow_size);
        this.originalBottomMargin = resources.getDimensionPixelSize(R.dimen.intercom_card_bottom_margin);
        this.shadowSizeDiff = this.expandedShadowSize - this.originalShadowSize;
    }

    public void animateToExpand() {
        ValueAnimator widthAnimator = ValueAnimator.ofInt((int[])new int[]{this.originalLeftMargin, this.expandedLeftMargin});
        widthAnimator.addUpdateListener(this.widthAnimateListener);
        ValueAnimator paddingAnimator = ValueAnimator.ofInt((int[])new int[]{this.originalPadding, this.expandedPadding});
        paddingAnimator.addUpdateListener(this.heightAnimateListener);
        ValueAnimator shadowAnimator = ValueAnimator.ofInt((int[])new int[]{this.originalShadowSize, this.expandedShadowSize});
        shadowAnimator.addUpdateListener(this.shadowAnimateListener);
        ValueAnimator verticalMarginAnimator = ValueAnimator.ofInt((int[])new int[]{0, this.shadowSizeDiff});
        verticalMarginAnimator.addUpdateListener(this.verticalMarginAnimateListener);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(400L);
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.playTogether(new Animator[]{widthAnimator, paddingAnimator, shadowAnimator, verticalMarginAnimator});
        animatorSet.start();
    }

    public void animateBack(Animator.AnimatorListener animateListener) {
        ValueAnimator widthAnimator = ValueAnimator.ofInt((int[])new int[]{this.expandedLeftMargin, this.originalLeftMargin});
        widthAnimator.addUpdateListener(this.widthAnimateListener);
        ValueAnimator paddingAnimator = ValueAnimator.ofInt((int[])new int[]{this.expandedPadding, this.originalPadding});
        paddingAnimator.addUpdateListener(this.heightAnimateListener);
        ValueAnimator shadowAnimator = ValueAnimator.ofInt((int[])new int[]{this.expandedShadowSize, this.originalShadowSize});
        shadowAnimator.addUpdateListener(this.shadowAnimateListener);
        ValueAnimator verticalMarginAnimator = ValueAnimator.ofInt((int[])new int[]{this.shadowSizeDiff, 0});
        verticalMarginAnimator.addUpdateListener(this.verticalMarginAnimateListener);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(400L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.playTogether(new Animator[]{widthAnimator, paddingAnimator, shadowAnimator, verticalMarginAnimator});
        animatorSet.addListener(animateListener);
        animatorSet.start();
    }

    public boolean isExpanded() {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        return MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)params) < this.originalLeftMargin;
    }
}

