/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.attribute.AttributeMetadata;
import io.intercom.android.sdk.models.Attribute;

public abstract class BaseAttributeView
extends LinearLayout {
    protected final TextView attributeNameView;
    protected final TextView attributeErrorView;
    @VisibleForTesting
    public final TextView attributePositionLabel;
    private Attribute attribute = Attribute.NULL;
    private AttributeMetadata metadata = AttributeMetadata.SINGLE_ATTRIBUTE_METADATA;

    public BaseAttributeView(Context context) {
        this(context, null);
    }

    public BaseAttributeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        BaseAttributeView.inflate((Context)this.getContext(), (int)this.getLayoutRes(), (ViewGroup)this);
        this.attributeNameView = (TextView)this.findViewById(R.id.attribute_name);
        this.attributeErrorView = (TextView)this.findViewById(R.id.error_text);
        this.attributePositionLabel = (TextView)this.findViewById(R.id.multi_attribute_label);
    }

    @LayoutRes
    public abstract int getLayoutRes();

    public abstract void displayErrorState(String var1);

    public abstract void displayEmptyState();

    public void setMetadata(AttributeMetadata metadata) {
        this.metadata = metadata;
    }

    public AttributeMetadata getMetadata() {
        return this.metadata;
    }

    public void showLabel(int renderedCount) {
        this.attributePositionLabel.setVisibility(0);
        this.attributePositionLabel.setText((CharSequence)("(" + renderedCount + " / " + this.metadata.getTotalCount() + ")"));
    }

    protected void setAttribute(Attribute attribute) {
        this.attribute = attribute;
        String name = attribute.getName();
        int realPosition = this.metadata.getPosition() + 1;
        if (this.metadata.getTotalCount() > 1) {
            this.attributeNameView.setText((CharSequence)(realPosition + ". " + name));
        } else {
            this.attributeNameView.setText((CharSequence)name);
        }
    }

    @NonNull
    public Attribute getAttribute() {
        return this.attribute;
    }

    protected void setError(String errorMessage) {
        this.attributeErrorView.setText((CharSequence)errorMessage);
        this.attributeErrorView.setVisibility(0);
    }

    protected void hideErrorView() {
        this.attributeErrorView.setVisibility(8);
    }
}

