/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.Attribute;
import io.intercom.android.sdk.models.AutoValue_Form;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.List;

@AutoValue
public abstract class Form
implements Parcelable {
    public static final Form NULL = Form.create(new ArrayList<Attribute>(), "");
    public static final Parcelable.Creator<Form> CREATOR = new Parcelable.Creator<Form>(){

        public Form createFromParcel(Parcel in) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            in.readList(attributes, Attribute.class.getClassLoader());
            String type = in.readString();
            return Form.create(attributes, type);
        }

        public Form[] newArray(int size) {
            return new Form[size];
        }
    };

    static Form create(List<Attribute> attributes, String type) {
        return new AutoValue_Form(attributes, type);
    }

    public abstract List<Attribute> getAttributes();

    public abstract String getType();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.getAttributes());
        dest.writeString(this.getType());
    }

    public static final class Builder {
        @Nullable
        List<Attribute.Builder> attributes;
        @Nullable
        String type;

        public Builder withAttributes(List<Attribute.Builder> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Form build() {
            ArrayList<Attribute> attributeList = new ArrayList<Attribute>(CollectionUtils.capacityFor(this.attributes));
            if (this.attributes != null) {
                for (Attribute.Builder builder : this.attributes) {
                    if (builder == null) continue;
                    attributeList.add(builder.build());
                }
            }
            return Form.create(attributeList, NullSafety.valueOrEmpty(this.type));
        }
    }
}

