/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import java.io.File;
import java.io.InputStream;

public class StringLoader<Data>
implements ModelLoader<String, Data> {
    private final ModelLoader<Uri, Data> uriLoader;

    public StringLoader(ModelLoader<Uri, Data> uriLoader) {
        this.uriLoader = uriLoader;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(String model, int width, int height, Options options) {
        Uri uri = StringLoader.parseUri(model);
        return uri == null ? null : this.uriLoader.buildLoadData(uri, width, height, options);
    }

    @Override
    public boolean handles(String model) {
        return true;
    }

    @Nullable
    private static Uri parseUri(String model) {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)model)) {
            return null;
        }
        if (model.startsWith("/")) {
            uri = StringLoader.toFileUri(model);
        } else {
            uri = Uri.parse((String)model);
            String scheme = uri.getScheme();
            if (scheme == null) {
                uri = StringLoader.toFileUri(model);
            }
        }
        return uri;
    }

    private static Uri toFileUri(String path) {
        return Uri.fromFile((File)new File(path));
    }

    public static class FileDescriptorFactory
    implements ModelLoaderFactory<String, ParcelFileDescriptor> {
        @Override
        public ModelLoader<String, ParcelFileDescriptor> build(MultiModelLoaderFactory multiFactory) {
            return new StringLoader<ParcelFileDescriptor>(multiFactory.build(Uri.class, ParcelFileDescriptor.class));
        }

        @Override
        public void teardown() {
        }
    }

    public static class StreamFactory
    implements ModelLoaderFactory<String, InputStream> {
        @Override
        public ModelLoader<String, InputStream> build(MultiModelLoaderFactory multiFactory) {
            return new StringLoader<InputStream>(multiFactory.build(Uri.class, InputStream.class));
        }

        @Override
        public void teardown() {
        }
    }
}

