/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ActivityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class OverlayStateReducer
implements Store.Reducer<OverlayState> {
    @SuppressLint(value={"StaticFieldLeak"})
    static final OverlayState INITIAL_STATE = OverlayState.create(Collections.emptyList(), Collections.emptySet(), Intercom.Visibility.VISIBLE, Intercom.Visibility.GONE, null, null, 0);

    OverlayStateReducer() {
    }

    @Override
    public OverlayState reduce(Action<?> action, OverlayState current) {
        switch (action.type()) {
            case SET_IN_APP_NOTIFICATION_VISIBILITY: {
                return current.toBuilder().notificationVisibility((Intercom.Visibility)((Object)action.value())).build();
            }
            case SET_LAUNCHER_VISIBILITY: {
                return current.toBuilder().launcherVisibility((Intercom.Visibility)((Object)action.value())).build();
            }
            case SET_BOTTOM_PADDING: {
                return current.toBuilder().bottomPadding((Integer)action.value()).build();
            }
            case HARD_RESET: {
                return current.toBuilder().conversations(Collections.emptyList()).dismissedPartIds(Collections.emptySet()).build();
            }
            case CONVERSATION_MARKED_AS_READ: {
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(current.conversations());
                OverlayStateReducer.removeConversationWithId(conversations, (String)action.value());
                return current.toBuilder().conversations(conversations).build();
            }
            case CONVERSATION_MARKED_AS_DISMISSED: {
                Conversation conversation = (Conversation)action.value();
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(current.conversations());
                HashSet<String> dismissedPartIds = new HashSet<String>(current.dismissedPartIds());
                dismissedPartIds.add(conversation.getLastPart().getId());
                OverlayStateReducer.removeDismissedConversations(conversations, dismissedPartIds);
                return current.toBuilder().conversations(conversations).dismissedPartIds(dismissedPartIds).build();
            }
            case UNREAD_CONVERSATIONS_SUCCESS: {
                UsersResponse response = (UsersResponse)action.value();
                List<Conversation> receivedConversations = response.getUnreadConversations().getConversations();
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(receivedConversations);
                OverlayStateReducer.removeDismissedConversations(conversations, current.dismissedPartIds());
                OverlayStateReducer.removeBadgeConversations(conversations);
                return current.toBuilder().conversations(conversations).build();
            }
            case ACTIVITY_READY_FOR_VIEW_ATTACHMENT: {
                Activity newActivity = (Activity)action.value();
                Activity newHostActivity = ActivityUtils.isHostActivity(newActivity) || ActivityUtils.isFullScreenHelpCenter(newActivity) ? newActivity : null;
                return OverlayStateReducer.newStateIfNewHostActivity(current, newHostActivity, null);
            }
            case ACTIVITY_PAUSED: {
                return OverlayStateReducer.newStateIfNewHostActivity(current, null, (Activity)action.value());
            }
            case ACTIVITY_STOPPED: {
                Activity stoppedActivity = (Activity)action.value();
                Activity newPausedActivity = stoppedActivity == current.pausedHostActivity() ? null : current.pausedHostActivity();
                return OverlayStateReducer.newStateIfNewHostActivity(current, current.resumedHostActivity(), newPausedActivity);
            }
            case APP_ENTERED_BACKGROUND: {
                return OverlayStateReducer.newStateIfNewHostActivity(current, null, null);
            }
        }
        return current;
    }

    private static void removeConversationWithId(List<Conversation> conversations, String conversationId) {
        for (Conversation conversation : conversations) {
            if (!conversation.getId().equals(conversationId)) continue;
            conversations.remove(conversation);
            break;
        }
    }

    private static OverlayState newStateIfNewHostActivity(OverlayState current, @Nullable Activity resumingActivity, @Nullable Activity pausingActivity) {
        if (current.resumedHostActivity() == resumingActivity && current.pausedHostActivity() == pausingActivity) {
            return current;
        }
        return current.toBuilder().resumedHostActivity(resumingActivity).pausedHostActivity(pausingActivity).build();
    }

    private static void removeDismissedConversations(List<Conversation> conversations, Set<String> dismissedPartIds) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (!dismissedPartIds.contains(conversations.get(i).getLastPart().getId())) continue;
            conversations.remove(i);
        }
    }

    private static void removeBadgeConversations(List<Conversation> conversations) {
        for (int i = conversations.size() - 1; i >= 0; --i) {
            if (conversations.get(i).getLastPart().getDeliveryOption() != Part.DeliveryOption.BADGE) continue;
            conversations.remove(i);
        }
    }
}

