/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model.stream;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.model.GlideUrl;
import io.intercom.com.bumptech.glide.load.model.Headers;
import io.intercom.com.bumptech.glide.load.model.ModelCache;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseGlideUrlLoader<Model>
implements ModelLoader<Model, InputStream> {
    private final ModelLoader<GlideUrl, InputStream> concreteLoader;
    @Nullable
    private final ModelCache<Model, GlideUrl> modelCache;

    protected BaseGlideUrlLoader(ModelLoader<GlideUrl, InputStream> concreteLoader) {
        this(concreteLoader, null);
    }

    protected BaseGlideUrlLoader(ModelLoader<GlideUrl, InputStream> concreteLoader, @Nullable ModelCache<Model, GlideUrl> modelCache) {
        this.concreteLoader = concreteLoader;
        this.modelCache = modelCache;
    }

    @Override
    @Nullable
    public ModelLoader.LoadData<InputStream> buildLoadData(Model model, int width, int height, Options options) {
        GlideUrl result = null;
        if (this.modelCache != null) {
            result = this.modelCache.get(model, width, height);
        }
        if (result == null) {
            String stringURL = this.getUrl(model, width, height, options);
            if (TextUtils.isEmpty((CharSequence)stringURL)) {
                return null;
            }
            result = new GlideUrl(stringURL, this.getHeaders(model, width, height, options));
            if (this.modelCache != null) {
                this.modelCache.put(model, width, height, result);
            }
        }
        List<String> alternateUrls = this.getAlternateUrls(model, width, height, options);
        ModelLoader.LoadData<InputStream> concreteLoaderData = this.concreteLoader.buildLoadData(result, width, height, options);
        if (concreteLoaderData == null || alternateUrls.isEmpty()) {
            return concreteLoaderData;
        }
        return new ModelLoader.LoadData<InputStream>(concreteLoaderData.sourceKey, BaseGlideUrlLoader.getAlternateKeys(alternateUrls), concreteLoaderData.fetcher);
    }

    private static List<Key> getAlternateKeys(List<String> alternateUrls) {
        ArrayList<Key> result = new ArrayList<Key>(alternateUrls.size());
        for (String alternate : alternateUrls) {
            result.add(new GlideUrl(alternate));
        }
        return result;
    }

    protected abstract String getUrl(Model var1, int var2, int var3, Options var4);

    protected List<String> getAlternateUrls(Model model, int width, int height, Options options) {
        return Collections.emptyList();
    }

    @Nullable
    protected Headers getHeaders(Model model, int width, int height, Options options) {
        return Headers.DEFAULT;
    }
}

