/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.models;

import android.os.Parcel;
import android.os.Parcelable;

public class Image
implements Parcelable {
    private final String alt;
    private final String url;
    private final String previewUrl;
    private final String attribution;
    private final int width;
    private final int height;
    public static final Parcelable.Creator<Image> CREATOR = new Parcelable.Creator<Image>(){

        public Image createFromParcel(Parcel in) {
            return new Image(in);
        }

        public Image[] newArray(int size) {
            return new Image[size];
        }
    };

    Image() {
        this(new Builder());
    }

    private Image(Builder builder) {
        this.alt = builder.alt == null ? "" : builder.alt;
        this.url = builder.url == null ? "" : builder.url;
        this.previewUrl = builder.previewUrl == null ? "" : builder.previewUrl;
        this.attribution = builder.attribution == null ? "" : builder.attribution;
        this.width = builder.width;
        this.height = builder.height;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getUrl() {
        return this.url;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image that = (Image)o;
        if (this.alt != null ? !this.alt.equals(that.alt) : that.alt != null) {
            return false;
        }
        if (this.previewUrl != null ? !this.previewUrl.equals(that.previewUrl) : that.previewUrl != null) {
            return false;
        }
        if (this.attribution != null ? !this.attribution.equals(that.attribution) : that.attribution != null) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        return !(this.url == null ? that.url != null : !this.url.equals(that.url));
    }

    public int hashCode() {
        int result = this.alt != null ? this.alt.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.previewUrl != null ? this.previewUrl.hashCode() : 0);
        result = 31 * result + (this.attribution != null ? this.attribution.hashCode() : 0);
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        return result;
    }

    protected Image(Parcel in) {
        this.attribution = in.readString();
        this.previewUrl = in.readString();
        this.alt = in.readString();
        this.url = in.readString();
        this.width = in.readInt();
        this.height = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.attribution);
        dest.writeString(this.previewUrl);
        dest.writeString(this.alt);
        dest.writeString(this.url);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
    }

    public static final class Builder {
        String alt;
        String url;
        String previewUrl;
        String attribution;
        int width;
        int height;

        public Builder withAlt(String alt) {
            this.alt = alt;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder withPreviewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
            return this;
        }

        public Builder withAttribution(String attribution) {
            this.attribution = attribution;
            return this;
        }

        public Image build() {
            return new Image(this);
        }
    }
}

