/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.imageloader;

import android.graphics.Bitmap;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.bumptech.glide.disklrucache.DiskLruCache;
import io.intercom.com.bumptech.glide.util.LruCache;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class LongTermImageDiskCache
implements Closeable {
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private final SafeKeyGenerator safeKeyGenerator;
    private final File directory;
    private final int maxSize;
    private final DiskCacheWriteLocker writeLocker = new DiskCacheWriteLocker();
    private DiskLruCache diskLruCache;
    private final Twig twig = LumberMill.getLogger();

    public LongTermImageDiskCache(File directory, int maxSize) {
        this.directory = directory;
        this.maxSize = maxSize;
        this.safeKeyGenerator = new SafeKeyGenerator();
    }

    private synchronized DiskLruCache getDiskCache() throws IOException {
        if (this.diskLruCache == null) {
            this.diskLruCache = DiskLruCache.open((File)this.directory, (int)1, (int)1, (long)this.maxSize);
        }
        return this.diskLruCache;
    }

    public File get(String key) {
        String safeKey = this.safeKeyGenerator.getSafeKey(key);
        File result = null;
        try {
            DiskLruCache.Value value = this.getDiskCache().get(safeKey);
            if (value != null) {
                result = value.getFile(0);
            }
        }
        catch (IOException e) {
            this.twig.e(e.getMessage(), new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Bitmap bitmap) {
        this.writeLocker.acquire(key);
        try {
            DiskLruCache diskCache;
            String safeKey;
            block11: {
                safeKey = this.safeKeyGenerator.getSafeKey(key);
                diskCache = this.getDiskCache();
                DiskLruCache.Value current = diskCache.get(safeKey);
                if (current == null) break block11;
                return;
            }
            try {
                DiskLruCache.Editor editor = diskCache.edit(safeKey);
                if (editor == null) {
                    throw new IllegalStateException("Had two simultaneous puts for: " + safeKey);
                }
                try {
                    File file = editor.getFile(0);
                    this.write(file, bitmap);
                    editor.commit();
                }
                finally {
                    editor.abortUnlessCommitted();
                }
            }
            catch (IOException e) {
                this.twig.e(e.getMessage(), new Object[0]);
            }
        }
        finally {
            this.writeLocker.release(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Bitmap bitmap) {
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            Bitmap.CompressFormat format = bitmap.hasAlpha() ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG;
            bitmap.compress(format, 100, os);
        }
        catch (FileNotFoundException e) {
            this.twig.e(e.getMessage(), new Object[0]);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void delete(String key) {
        String safeKey = this.safeKeyGenerator.getSafeKey(key);
        try {
            this.getDiskCache().remove(safeKey);
        }
        catch (IOException e) {
            this.twig.e(e.getMessage(), new Object[0]);
        }
    }

    public synchronized void clear() {
        try {
            this.getDiskCache().delete();
            this.resetDiskCache();
        }
        catch (IOException e) {
            this.twig.e(e.getMessage(), new Object[0]);
        }
    }

    private synchronized void resetDiskCache() {
        this.diskLruCache = null;
    }

    public boolean isClosed() {
        return this.diskLruCache == null || this.diskLruCache.isClosed();
    }

    @Override
    public void close() throws IOException {
        if (this.diskLruCache != null) {
            this.diskLruCache.close();
        }
    }

    private static class DiskCacheWriteLocker {
        private final Map<String, WriteLock> locks = new HashMap<String, WriteLock>();
        private final WriteLockPool writeLockPool = new WriteLockPool();

        DiskCacheWriteLocker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void acquire(String key) {
            WriteLock writeLock;
            DiskCacheWriteLocker diskCacheWriteLocker = this;
            synchronized (diskCacheWriteLocker) {
                writeLock = this.locks.get(key);
                if (writeLock == null) {
                    writeLock = this.writeLockPool.obtain();
                    this.locks.put(key, writeLock);
                }
                ++writeLock.interestedThreads;
            }
            writeLock.lock.lock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(String key) {
            WriteLock writeLock;
            DiskCacheWriteLocker diskCacheWriteLocker = this;
            synchronized (diskCacheWriteLocker) {
                writeLock = this.locks.get(key);
                if (writeLock == null || writeLock.interestedThreads <= 0) {
                    throw new IllegalArgumentException("Cannot release a lock that is not held, key: " + key + ", interestedThreads: " + (writeLock == null ? 0 : writeLock.interestedThreads));
                }
                if (--writeLock.interestedThreads == 0) {
                    WriteLock removed = this.locks.remove(key);
                    if (!removed.equals(writeLock)) {
                        throw new IllegalStateException("Removed the wrong lock, expected to remove: " + writeLock + ", but actually removed: " + removed + ", key: " + key);
                    }
                    this.writeLockPool.offer(removed);
                }
            }
            writeLock.lock.unlock();
        }

        private class WriteLockPool {
            private static final int MAX_POOL_SIZE = 10;
            private final Queue<WriteLock> pool = new ArrayDeque<WriteLock>();

            WriteLockPool() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            WriteLock obtain() {
                WriteLock result;
                Queue<WriteLock> queue = this.pool;
                synchronized (queue) {
                    result = this.pool.poll();
                }
                if (result == null) {
                    result = new WriteLock();
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void offer(WriteLock writeLock) {
                Queue<WriteLock> queue = this.pool;
                synchronized (queue) {
                    if (this.pool.size() < 10) {
                        this.pool.offer(writeLock);
                    }
                }
            }
        }

        private class WriteLock {
            final Lock lock = new ReentrantLock();
            int interestedThreads;

            WriteLock() {
            }
        }
    }

    private static class SafeKeyGenerator {
        private final LruCache<String, String> loadIdToSafeHash = new LruCache(1000L);

        SafeKeyGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSafeKey(String key) {
            String safeKey;
            LruCache<String, String> lruCache = this.loadIdToSafeHash;
            synchronized (lruCache) {
                safeKey = (String)this.loadIdToSafeHash.get((Object)key);
            }
            if (safeKey == null) {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                    messageDigest.update(key.getBytes("UTF-8"));
                    safeKey = Util.sha256BytesToHex((byte[])messageDigest.digest());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                lruCache = this.loadIdToSafeHash;
                synchronized (lruCache) {
                    this.loadIdToSafeHash.put((Object)key, (Object)safeKey);
                }
            }
            return safeKey;
        }
    }
}

