/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.messengercard.CardWebView;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewPresenter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.squareup.otto.Bus;

public class MessengerAppCardViewHolder
extends RecyclerView.ViewHolder {
    private final CardWebView webView;
    private final ProgressBar loadingView;
    private final Bus bus;
    private final Provider<AppConfig> appConfigProvider;
    private final Gson gson;
    private final MetricTracker metricTracker;

    MessengerAppCardViewHolder(View itemView, Bus bus, Provider<AppConfig> appConfigProvider, Gson gson, MetricTracker metricTracker) {
        super(itemView);
        this.webView = MessengerCardWebViewPresenter.createCardWebView(itemView.getContext());
        ((FrameLayout)itemView).addView((View)this.webView);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.webView.getResources().getDimensionPixelSize(R.dimen.intercom_home_app_card_min_height)));
        this.loadingView = (ProgressBar)itemView.findViewById(R.id.loading_view);
        this.bus = bus;
        this.appConfigProvider = appConfigProvider;
        this.gson = gson;
        this.metricTracker = metricTracker;
        FrameLayout rootLayout = (FrameLayout)itemView.findViewById(R.id.messenger_card_layout);
        ColorUtils.updateInnerBorderColor(appConfigProvider.get(), (View)rootLayout);
    }

    public void bindCard(String cardUrl) {
        MessengerCardWebViewPresenter presenter = new MessengerCardWebViewPresenter(this.webView, (View)this.loadingView, cardUrl, this.bus, this.appConfigProvider.get().getPrimaryColor(), this.gson, this.metricTracker, this.webView.getContext().getCacheDir(), "", true);
        presenter.setUpWebView();
        if (!TextUtils.isEmpty((CharSequence)cardUrl)) {
            this.webView.loadUrl(cardUrl);
        }
    }
}

