/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryInputDataSource;
import com.intercom.input.gallery.GalleryInputFragment;
import com.intercom.input.gallery.GalleryLightBoxFragment;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.composer.galleryinput.DownscaleOnlyCenterCrop;
import io.intercom.android.sdk.conversation.composer.galleryinput.GalleryImageLoader;
import io.intercom.android.sdk.conversation.composer.galleryinput.GifInputDataSource;
import io.intercom.android.sdk.conversation.composer.galleryinput.GifLightBoxFragment;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapTransformation;

class GifInputInjector
implements GalleryInputFragment.Injector {
    private final RequestManager requestManager;
    private final GifInputDataSource dataSource = new GifInputDataSource(Injector.get().getApi(), Injector.get().getMetricTracker());

    public GifInputInjector(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    @Nullable
    public View getExpanderButton(ViewGroup parent) {
        return null;
    }

    @Nullable
    public View getSearchView(ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.intercom_gif_input_search, parent, false);
    }

    public Toolbar getToolbar(ViewGroup parent) {
        Toolbar toolbar = (Toolbar)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.intercom_gif_input_toolbar, parent, false);
        final ImageButton clearButton = (ImageButton)toolbar.findViewById(R.id.clear_search);
        final EditText searchView = (EditText)toolbar.findViewById(R.id.search_bar);
        searchView.requestFocus();
        searchView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable text) {
                clearButton.setVisibility(TextUtils.isEmpty((CharSequence)text) ? 8 : 0);
                GifInputInjector.this.dataSource.getImages(0, text.toString());
            }
        });
        clearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                searchView.setText(null);
            }
        });
        return toolbar;
    }

    public int getThemeColor(Context context) {
        AppConfig appConfig = Injector.get().getAppConfigProvider().get();
        return ColorUtils.primaryOrDarkColor(context, appConfig);
    }

    public GalleryInputDataSource getDataSource(GalleryInputFragment fragment) {
        return this.dataSource;
    }

    public ImageLoader getImageLoader(GalleryInputFragment fragment) {
        return GalleryImageLoader.create(DiskCacheStrategy.DATA, (BitmapTransformation)DownscaleOnlyCenterCrop.INSTANCE, this.requestManager);
    }

    public Class<? extends GalleryLightBoxFragment> getLightBoxFragmentClass(GalleryInputFragment fragment) {
        return GifLightBoxFragment.class;
    }

    public String getEmptyViewTitle(Resources resources) {
        return resources.getString(R.string.intercom_no_gifs_found);
    }

    public String getEmptyViewSubtitle(Resources resources) {
        return resources.getString(R.string.intercom_no_gifs_matching_query);
    }

    public String getErrorViewTitle(Resources resources) {
        return resources.getString(R.string.intercom_gifs_load_error);
    }

    public String getErrorViewSubtitle(Resources resources) {
        return resources.getString(R.string.intercom_try_again_minute);
    }
}

