/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.retrofit2.converter.gson;

import io.intercom.com.google.gson.Gson;
import io.intercom.com.google.gson.TypeAdapter;
import io.intercom.com.google.gson.stream.JsonWriter;
import io.intercom.okhttp3.MediaType;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okio.Buffer;
import io.intercom.retrofit2.Converter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

final class GsonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json; charset=UTF-8");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    GsonRequestBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    @Override
    public RequestBody convert(T value) throws IOException {
        Buffer buffer = new Buffer();
        OutputStreamWriter writer = new OutputStreamWriter(buffer.outputStream(), UTF_8);
        JsonWriter jsonWriter = this.gson.newJsonWriter(writer);
        this.adapter.write(jsonWriter, value);
        jsonWriter.close();
        return RequestBody.create(MEDIA_TYPE, buffer.readByteString());
    }
}

