/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.provider;

import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import io.intercom.com.bumptech.glide.load.engine.LoadPath;
import io.intercom.com.bumptech.glide.util.MultiClassKey;
import java.util.concurrent.atomic.AtomicReference;

public class LoadPathCache {
    private final ArrayMap<MultiClassKey, LoadPath<?, ?, ?>> cache = new ArrayMap();
    private final AtomicReference<MultiClassKey> keyRef = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Class<?> dataClass, Class<?> resourceClass, Class<?> transcodeClass) {
        boolean result;
        MultiClassKey key = this.getKey(dataClass, resourceClass, transcodeClass);
        ArrayMap<MultiClassKey, LoadPath<?, ?, ?>> arrayMap = this.cache;
        synchronized (arrayMap) {
            result = this.cache.containsKey((Object)key);
        }
        this.keyRef.set(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <Data, TResource, Transcode> LoadPath<Data, TResource, Transcode> get(Class<Data> dataClass, Class<TResource> resourceClass, Class<Transcode> transcodeClass) {
        LoadPath result;
        MultiClassKey key = this.getKey(dataClass, resourceClass, transcodeClass);
        ArrayMap<MultiClassKey, LoadPath<?, ?, ?>> arrayMap = this.cache;
        synchronized (arrayMap) {
            result = (LoadPath)this.cache.get((Object)key);
        }
        this.keyRef.set(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Class<?> dataClass, Class<?> resourceClass, Class<?> transcodeClass, LoadPath<?, ?, ?> loadPath) {
        ArrayMap<MultiClassKey, LoadPath<?, ?, ?>> arrayMap = this.cache;
        synchronized (arrayMap) {
            this.cache.put((Object)new MultiClassKey(dataClass, resourceClass, transcodeClass), loadPath);
        }
    }

    private MultiClassKey getKey(Class<?> dataClass, Class<?> resourceClass, Class<?> transcodeClass) {
        MultiClassKey key = this.keyRef.getAndSet(null);
        if (key == null) {
            key = new MultiClassKey();
        }
        key.set(dataClass, resourceClass, transcodeClass);
        return key;
    }
}

