/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.com.bumptech.glide.util.Preconditions;

public final class PreFillType {
    @VisibleForTesting
    static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.RGB_565;
    private final int width;
    private final int height;
    private final Bitmap.Config config;
    private final int weight;

    PreFillType(int width, int height, Bitmap.Config config, int weight) {
        this.config = Preconditions.checkNotNull(config, "Config must not be null");
        this.width = width;
        this.height = height;
        this.weight = weight;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    Bitmap.Config getConfig() {
        return this.config;
    }

    int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o instanceof PreFillType) {
            PreFillType other = (PreFillType)o;
            return this.height == other.height && this.width == other.width && this.weight == other.weight && this.config == other.config;
        }
        return false;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.config.hashCode();
        result = 31 * result + this.weight;
        return result;
    }

    public String toString() {
        return "PreFillSize{width=" + this.width + ", height=" + this.height + ", config=" + this.config + ", weight=" + this.weight + '}';
    }

    public static class Builder {
        private final int width;
        private final int height;
        private Bitmap.Config config;
        private int weight = 1;

        public Builder(int size) {
            this(size, size);
        }

        public Builder(int width, int height) {
            if (width <= 0) {
                throw new IllegalArgumentException("Width must be > 0");
            }
            if (height <= 0) {
                throw new IllegalArgumentException("Height must be > 0");
            }
            this.width = width;
            this.height = height;
        }

        public Builder setConfig(@Nullable Bitmap.Config config) {
            this.config = config;
            return this;
        }

        Bitmap.Config getConfig() {
            return this.config;
        }

        public Builder setWeight(int weight) {
            if (weight <= 0) {
                throw new IllegalArgumentException("Weight must be > 0");
            }
            this.weight = weight;
            return this;
        }

        PreFillType build() {
            return new PreFillType(this.width, this.height, this.config, this.weight);
        }
    }
}

