/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EdgeEffect;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ViewUtils {
    private static final Twig twig = LumberMill.getLogger();

    public static void removeGlobalLayoutListener(View view, ViewTreeObserver.OnGlobalLayoutListener listener) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.getViewTreeObserver().removeOnGlobalLayoutListener(listener);
        } else {
            view.getViewTreeObserver().removeGlobalOnLayoutListener(listener);
        }
    }

    public static void waitForViewAttachment(final View view, final Runnable runnable) {
        if (view.getHeight() == 0) {
            view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ViewUtils.removeGlobalLayoutListener(view, this);
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    public static void setOverScrollColour(RecyclerView view, int color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Class<RecyclerView> clazz = RecyclerView.class;
                for (String name : new String[]{"ensureTopGlow", "ensureBottomGlow"}) {
                    Method method = clazz.getDeclaredMethod(name, new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)view, new Object[0]);
                }
                for (String name : new String[]{"mTopGlow", "mBottomGlow"}) {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    Object edge = field.get(view);
                    Field edgeEffect = edge.getClass().getDeclaredField("mEdgeEffect");
                    edgeEffect.setAccessible(true);
                    ((EdgeEffect)edgeEffect.get(edge)).setColor(color2);
                }
            }
            catch (Exception ignored) {
                twig.d("Could not set overscroll colour", new Object[0]);
            }
        }
    }

    public static void requestLayoutIfPossible(View view) {
        if (Build.VERSION.SDK_INT < 18 || !view.isInLayout()) {
            view.requestLayout();
        }
    }
}

