/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BackgroundUtils;

public class ColorUtils {
    public static int lightenColor(int color2) {
        int resultR = (Color.red((int)color2) + 255) / 2;
        int resultG = (Color.green((int)color2) + 255) / 2;
        int resultB = (Color.blue((int)color2) + 255) / 2;
        return Color.argb((int)Color.alpha((int)color2), (int)resultR, (int)resultG, (int)resultB);
    }

    public static int darkenColor(int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = hsv[2] * 0.79f;
        return Color.HSVToColor((float[])hsv);
    }

    public static ColorFilter newGreyscaleFilter() {
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        return new ColorMatrixColorFilter(colorMatrix);
    }

    public static void setTextColorWhiteOrDark(TextView textView, boolean shouldRenderDarkText) {
        int textColor = ColorUtils.whiteOrDarkColor(textView.getContext(), shouldRenderDarkText);
        textView.setTextColor(textColor);
        textView.setLinkTextColor(textColor);
    }

    public static void setTextColorPrimaryOrDark(TextView textView, AppConfig appConfig) {
        int textColor = ColorUtils.primaryOrDarkColor(textView.getContext(), appConfig);
        textView.setTextColor(textColor);
        textView.setLinkTextColor(textColor);
    }

    @ColorInt
    public static int primaryOrDarkColor(Context context, AppConfig appConfig) {
        return appConfig.primaryColorRenderDarkText() ? ContextCompat.getColor((Context)context, (int)R.color.intercom_black) : appConfig.getPrimaryColor();
    }

    @ColorInt
    public static int whiteOrDarkColor(Context context, boolean shouldRenderDarkText) {
        return shouldRenderDarkText ? ContextCompat.getColor((Context)context, (int)R.color.intercom_black) : ContextCompat.getColor((Context)context, (int)R.color.intercom_white);
    }

    public static void setImageColorWhiteOrDark(ImageView view, boolean shouldRenderDarkImage) {
        int imageColorRes = shouldRenderDarkImage ? R.color.intercom_black : R.color.intercom_white;
        int imageColor = ContextCompat.getColor((Context)view.getContext(), (int)imageColorRes);
        view.setColorFilter(imageColor);
    }

    public static void updateInnerBorderColor(AppConfig appConfig, View view) {
        int primaryColor = appConfig.getPrimaryColor();
        LayerDrawable cardBackgroundDrawable = (LayerDrawable)ContextCompat.getDrawable((Context)view.getContext(), (int)R.drawable.intercom_conversation_card_with_top_border);
        Drawable topBorderDrawable = cardBackgroundDrawable.findDrawableByLayerId(R.id.top_border);
        topBorderDrawable.setAlpha(127);
        topBorderDrawable.setColorFilter(primaryColor, PorterDuff.Mode.SRC_IN);
        BackgroundUtils.setBackground(view, (Drawable)cardBackgroundDrawable);
    }
}

