/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.AutoValue_Participant;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.utilities.NullSafety;

@AutoValue
public abstract class Participant
implements Parcelable {
    public static final String ADMIN_TYPE = "admin";
    static final String USER_TYPE = "user";
    public static final Participant NULL = Participant.create("", "", "", "", Avatar.create("", ""), false);
    public static final Parcelable.Creator<Participant> CREATOR = new Parcelable.Creator<Participant>(){

        public Participant createFromParcel(Parcel in) {
            String id2 = in.readString();
            String name = in.readString();
            String type = in.readString();
            String email = in.readString();
            Avatar avatar = (Avatar)in.readValue(Avatar.class.getClassLoader());
            Boolean isBot = in.readByte() == 0;
            return Participant.create(id2, name, type, email, avatar, isBot);
        }

        public Participant[] newArray(int size) {
            return new Participant[size];
        }
    };

    public static Participant create(String id2, String name, String type, String email, Avatar avatar, Boolean isBot) {
        return new AutoValue_Participant(id2, name, type, email, avatar, isBot);
    }

    public abstract String getId();

    public abstract String getName();

    public abstract String getType();

    public abstract String getEmail();

    public abstract Avatar getAvatar();

    public abstract Boolean isBot();

    public boolean isAdmin() {
        return ADMIN_TYPE.equals(this.getType());
    }

    @VisibleForTesting
    String nameOrEmail() {
        return this.getName().isEmpty() ? this.getEmail() : this.getName();
    }

    public String getForename() {
        return this.nameOrEmail().trim().split(" ")[0];
    }

    public boolean isUserWithId(@Nullable String userId) {
        return USER_TYPE.equals(this.getType()) && this.getId().equals(userId);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getId());
        dest.writeString(this.getName());
        dest.writeString(this.getType());
        dest.writeString(this.getEmail());
        dest.writeValue((Object)this.getAvatar());
        dest.writeByte((byte)(this.isBot() != false ? 1 : 0));
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String type;
        @Nullable
        String email;
        @Nullable
        Avatar.Builder avatar;
        @Nullable
        Boolean is_bot;

        public Participant build() {
            String type = this.type == null ? Participant.USER_TYPE : this.type;
            String name = NullSafety.valueOrEmpty(this.name);
            String email = NullSafety.valueOrEmpty(this.email);
            String initial = NameUtils.getInitial(name.isEmpty() ? email : name);
            Avatar avatar = this.avatar == null ? Avatar.create("", initial) : this.avatar.withInitials(initial).build();
            Boolean isBot = NullSafety.valueOrDefault(this.is_bot, false);
            return Participant.create(NullSafety.valueOrEmpty(this.id), name, type, email, avatar, isBot);
        }

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }
    }
}

