/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.experimental;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;

public class IntercomSettings {
    private final Twig twig = LumberMill.getLogger();
    private String apiKey = "";
    private String appId = "";
    private String email = "";
    private String userId = "";
    private String userHash = "";

    public static IntercomSettings create() {
        return new IntercomSettings();
    }

    public IntercomSettings withApiKey(@NonNull String apiKey) {
        boolean validKey;
        boolean bl = validKey = !TextUtils.isEmpty((CharSequence)apiKey);
        if (validKey) {
            this.apiKey = apiKey;
        } else {
            this.twig.e("apiKey cannot be null or empty", new Object[0]);
        }
        return this;
    }

    public IntercomSettings withAppId(@NonNull String appId) {
        boolean validId;
        boolean bl = validId = !TextUtils.isEmpty((CharSequence)appId);
        if (validId) {
            this.appId = appId;
        } else {
            this.twig.e("appId cannot be null or empty", new Object[0]);
        }
        return this;
    }

    public IntercomSettings withEmail(@NonNull String email) {
        boolean validEmail;
        boolean bl = validEmail = !TextUtils.isEmpty((CharSequence)email);
        if (validEmail) {
            this.email = email;
        } else {
            this.twig.e("email cannot be null or empty", new Object[0]);
        }
        return this;
    }

    public IntercomSettings withUserId(@NonNull String userId) {
        boolean validUserId;
        boolean bl = validUserId = !TextUtils.isEmpty((CharSequence)userId);
        if (validUserId) {
            this.userId = userId;
        } else {
            this.twig.e("userId cannot be null or empty", new Object[0]);
        }
        return this;
    }

    public IntercomSettings withUserHash(@NonNull String userHash) {
        boolean validUserHash;
        boolean bl = validUserHash = !TextUtils.isEmpty((CharSequence)userHash);
        if (validUserHash) {
            this.userHash = userHash;
        } else {
            this.twig.e("userHash cannot be null or empty", new Object[0]);
        }
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserHash() {
        return this.userHash;
    }

    public boolean canIdentifyUser() {
        return !TextUtils.isEmpty((CharSequence)this.userId) || !TextUtils.isEmpty((CharSequence)this.email);
    }
}

