/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine.bitmap_recycle;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ArrayAdapterInterface;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BaseKeyPool;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ByteArrayAdapter;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.IntegerArrayAdapter;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.Poolable;
import io.intercom.com.bumptech.glide.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public final class LruArrayPool
implements ArrayPool {
    static final int DEFAULT_SIZE = 0x400000;
    private static final int MAX_OVER_SIZE_MULTIPLE = 8;
    private static final int SINGLE_ARRAY_MAX_SIZE_DIVISOR = 2;
    private final GroupedLinkedMap<Key, Object> groupedMap = new GroupedLinkedMap();
    private final KeyPool keyPool = new KeyPool();
    private final Map<Class<?>, NavigableMap<Integer, Integer>> sortedSizes = new HashMap();
    private final Map<Class<?>, ArrayAdapterInterface<?>> adapters = new HashMap();
    private final int maxSize;
    private int currentSize;

    @VisibleForTesting
    public LruArrayPool() {
        this.maxSize = 0x400000;
    }

    public LruArrayPool(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public synchronized <T> void put(T array, Class<T> arrayClass) {
        ArrayAdapterInterface<T> arrayAdapter = this.getAdapterFromType(arrayClass);
        int size = arrayAdapter.getArrayLength(array);
        int arrayBytes = size * arrayAdapter.getElementSizeInBytes();
        if (!this.isSmallEnoughForReuse(arrayBytes)) {
            return;
        }
        Key key = this.keyPool.get(size, arrayClass);
        this.groupedMap.put(key, array);
        NavigableMap<Integer, Integer> sizes = this.getSizesForAdapter(arrayClass);
        Integer current = (Integer)sizes.get(key.size);
        sizes.put(key.size, current == null ? 1 : current + 1);
        this.currentSize += arrayBytes;
        this.evict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(int size, Class<T> arrayClass) {
        T result;
        ArrayAdapterInterface<T> arrayAdapter = this.getAdapterFromType(arrayClass);
        LruArrayPool lruArrayPool = this;
        synchronized (lruArrayPool) {
            Integer possibleSize = this.getSizesForAdapter(arrayClass).ceilingKey(size);
            Key key = this.mayFillRequest(size, possibleSize) ? this.keyPool.get(possibleSize, arrayClass) : this.keyPool.get(size, arrayClass);
            result = this.getArrayForKey(key);
            if (result != null) {
                this.currentSize -= arrayAdapter.getArrayLength(result) * arrayAdapter.getElementSizeInBytes();
                this.decrementArrayOfSize(arrayAdapter.getArrayLength(result), arrayClass);
            }
        }
        if (result == null) {
            if (Log.isLoggable((String)arrayAdapter.getTag(), (int)2)) {
                Log.v((String)arrayAdapter.getTag(), (String)("Allocated " + size + " bytes"));
            }
            result = arrayAdapter.newArray(size);
        }
        return result;
    }

    @Nullable
    private <T> T getArrayForKey(Key key) {
        return (T)this.groupedMap.get(key);
    }

    private boolean isSmallEnoughForReuse(int byteSize) {
        return byteSize <= this.maxSize / 2;
    }

    private boolean mayFillRequest(int requestedSize, Integer actualSize) {
        return actualSize != null && (this.isNoMoreThanHalfFull() || actualSize <= 8 * requestedSize);
    }

    private boolean isNoMoreThanHalfFull() {
        return this.currentSize == 0 || this.maxSize / this.currentSize >= 2;
    }

    @Override
    public synchronized void clearMemory() {
        this.evictToSize(0);
    }

    @Override
    public synchronized void trimMemory(int level) {
        if (level >= 40) {
            this.clearMemory();
        } else if (level >= 20) {
            this.evictToSize(this.maxSize / 2);
        }
    }

    private void evict() {
        this.evictToSize(this.maxSize);
    }

    private void evictToSize(int size) {
        while (this.currentSize > size) {
            Object evicted = this.groupedMap.removeLast();
            Preconditions.checkNotNull(evicted);
            ArrayAdapterInterface<Object> arrayAdapter = this.getAdapterFromObject(evicted);
            this.currentSize -= arrayAdapter.getArrayLength(evicted) * arrayAdapter.getElementSizeInBytes();
            this.decrementArrayOfSize(arrayAdapter.getArrayLength(evicted), evicted.getClass());
            if (!Log.isLoggable((String)arrayAdapter.getTag(), (int)2)) continue;
            Log.v((String)arrayAdapter.getTag(), (String)("evicted: " + arrayAdapter.getArrayLength(evicted)));
        }
    }

    private void decrementArrayOfSize(int size, Class<?> arrayClass) {
        NavigableMap<Integer, Integer> sizes = this.getSizesForAdapter(arrayClass);
        Integer current = (Integer)sizes.get(size);
        if (current == null) {
            throw new NullPointerException("Tried to decrement empty size, size: " + size + ", this: " + this);
        }
        if (current == 1) {
            sizes.remove(size);
        } else {
            sizes.put(size, current - 1);
        }
    }

    private NavigableMap<Integer, Integer> getSizesForAdapter(Class<?> arrayClass) {
        NavigableMap<Integer, Integer> sizes = this.sortedSizes.get(arrayClass);
        if (sizes == null) {
            sizes = new TreeMap<Integer, Integer>();
            this.sortedSizes.put(arrayClass, sizes);
        }
        return sizes;
    }

    private <T> ArrayAdapterInterface<T> getAdapterFromObject(T object) {
        return this.getAdapterFromType(object.getClass());
    }

    private <T> ArrayAdapterInterface<T> getAdapterFromType(Class<T> arrayPoolClass) {
        ArrayAdapterInterface<int[]> adapter = this.adapters.get(arrayPoolClass);
        if (adapter == null) {
            if (arrayPoolClass.equals(int[].class)) {
                adapter = new IntegerArrayAdapter();
            } else if (arrayPoolClass.equals(byte[].class)) {
                adapter = new ByteArrayAdapter();
            } else {
                throw new IllegalArgumentException("No array pool found for: " + arrayPoolClass.getSimpleName());
            }
            this.adapters.put(arrayPoolClass, adapter);
        }
        return adapter;
    }

    int getCurrentSize() {
        int currentSize = 0;
        for (Class<?> type : this.sortedSizes.keySet()) {
            for (Integer size : this.sortedSizes.get(type).keySet()) {
                ArrayAdapterInterface<?> adapter = this.getAdapterFromType(type);
                currentSize += size * (Integer)this.sortedSizes.get(type).get(size) * adapter.getElementSizeInBytes();
            }
        }
        return currentSize;
    }

    private static final class Key
    implements Poolable {
        private final KeyPool pool;
        int size;
        private Class<?> arrayClass;

        Key(KeyPool pool) {
            this.pool = pool;
        }

        void init(int length, Class<?> arrayClass) {
            this.size = length;
            this.arrayClass = arrayClass;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return this.size == other.size && this.arrayClass == other.arrayClass;
            }
            return false;
        }

        public String toString() {
            return "Key{size=" + this.size + "array=" + this.arrayClass + '}';
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public int hashCode() {
            int result = this.size;
            result = 31 * result + (this.arrayClass != null ? this.arrayClass.hashCode() : 0);
            return result;
        }
    }

    private static final class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        Key get(int size, Class<?> arrayClass) {
            Key result = (Key)this.get();
            result.init(size, arrayClass);
            return result;
        }

        @Override
        protected Key create() {
            return new Key(this);
        }
    }
}

