/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.RequestBuilder;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.resource.gif.GifDrawable;
import io.intercom.com.bumptech.glide.manager.ConnectivityMonitor;
import io.intercom.com.bumptech.glide.manager.ConnectivityMonitorFactory;
import io.intercom.com.bumptech.glide.manager.Lifecycle;
import io.intercom.com.bumptech.glide.manager.LifecycleListener;
import io.intercom.com.bumptech.glide.manager.RequestManagerTreeNode;
import io.intercom.com.bumptech.glide.manager.RequestTracker;
import io.intercom.com.bumptech.glide.manager.TargetTracker;
import io.intercom.com.bumptech.glide.request.Request;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.request.target.ViewTarget;
import io.intercom.com.bumptech.glide.request.transition.Transition;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.File;

public class RequestManager
implements LifecycleListener {
    private static final RequestOptions DECODE_TYPE_BITMAP = RequestOptions.decodeTypeOf(Bitmap.class).lock();
    private static final RequestOptions DECODE_TYPE_GIF = RequestOptions.decodeTypeOf(GifDrawable.class).lock();
    private static final RequestOptions DOWNLOAD_ONLY_OPTIONS = RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.DATA).priority(Priority.LOW).skipMemoryCache(true);
    protected final Glide glide;
    final Lifecycle lifecycle;
    private final RequestTracker requestTracker;
    private final RequestManagerTreeNode treeNode;
    private final TargetTracker targetTracker = new TargetTracker();
    private final Runnable addSelfToLifecycle = new Runnable(){

        @Override
        public void run() {
            RequestManager.this.lifecycle.addListener(RequestManager.this);
        }
    };
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final ConnectivityMonitor connectivityMonitor;
    @NonNull
    private RequestOptions requestOptions;

    public RequestManager(Glide glide, Lifecycle lifecycle, RequestManagerTreeNode treeNode) {
        this(glide, lifecycle, treeNode, new RequestTracker(), glide.getConnectivityMonitorFactory());
    }

    RequestManager(Glide glide, Lifecycle lifecycle, RequestManagerTreeNode treeNode, RequestTracker requestTracker, ConnectivityMonitorFactory factory) {
        this.glide = glide;
        this.lifecycle = lifecycle;
        this.treeNode = treeNode;
        this.requestTracker = requestTracker;
        Context context = glide.getGlideContext().getBaseContext();
        this.connectivityMonitor = factory.build(context, new RequestManagerConnectivityListener(requestTracker));
        if (Util.isOnBackgroundThread()) {
            this.mainHandler.post(this.addSelfToLifecycle);
        } else {
            lifecycle.addListener(this);
        }
        lifecycle.addListener(this.connectivityMonitor);
        this.setRequestOptions(glide.getGlideContext().getDefaultRequestOptions());
        glide.registerRequestManager(this);
    }

    protected void setRequestOptions(@NonNull RequestOptions toSet) {
        this.requestOptions = toSet.clone().autoClone();
    }

    private void updateRequestOptions(RequestOptions toUpdate) {
        this.requestOptions = this.requestOptions.apply(toUpdate);
    }

    public RequestManager applyDefaultRequestOptions(RequestOptions requestOptions) {
        this.updateRequestOptions(requestOptions);
        return this;
    }

    public RequestManager setDefaultRequestOptions(RequestOptions requestOptions) {
        this.setRequestOptions(requestOptions);
        return this;
    }

    @Deprecated
    public void onTrimMemory(int level) {
        this.glide.onTrimMemory(level);
    }

    @Deprecated
    public void onLowMemory() {
        this.glide.onLowMemory();
    }

    public boolean isPaused() {
        Util.assertMainThread();
        return this.requestTracker.isPaused();
    }

    public void pauseRequests() {
        Util.assertMainThread();
        this.requestTracker.pauseRequests();
    }

    public void pauseRequestsRecursive() {
        Util.assertMainThread();
        this.pauseRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.pauseRequests();
        }
    }

    public void resumeRequests() {
        Util.assertMainThread();
        this.requestTracker.resumeRequests();
    }

    public void resumeRequestsRecursive() {
        Util.assertMainThread();
        this.resumeRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.resumeRequests();
        }
    }

    @Override
    public void onStart() {
        this.resumeRequests();
        this.targetTracker.onStart();
    }

    @Override
    public void onStop() {
        this.pauseRequests();
        this.targetTracker.onStop();
    }

    @Override
    public void onDestroy() {
        this.targetTracker.onDestroy();
        for (Target<?> target : this.targetTracker.getAll()) {
            this.clear(target);
        }
        this.targetTracker.clear();
        this.requestTracker.clearRequests();
        this.lifecycle.removeListener(this);
        this.lifecycle.removeListener(this.connectivityMonitor);
        this.mainHandler.removeCallbacks(this.addSelfToLifecycle);
        this.glide.unregisterRequestManager(this);
    }

    public RequestBuilder<Bitmap> asBitmap() {
        return this.as(Bitmap.class).apply(DECODE_TYPE_BITMAP);
    }

    public RequestBuilder<GifDrawable> asGif() {
        return this.as(GifDrawable.class).apply(DECODE_TYPE_GIF);
    }

    public RequestBuilder<Drawable> asDrawable() {
        return this.as(Drawable.class);
    }

    public RequestBuilder<Drawable> load(@Nullable Object model) {
        return this.asDrawable().load(model);
    }

    public RequestBuilder<File> downloadOnly() {
        return this.as(File.class).apply(DOWNLOAD_ONLY_OPTIONS);
    }

    public RequestBuilder<File> download(@Nullable Object model) {
        return this.downloadOnly().load(model);
    }

    public RequestBuilder<File> asFile() {
        return this.as(File.class).apply(RequestOptions.skipMemoryCacheOf(true));
    }

    public <ResourceType> RequestBuilder<ResourceType> as(Class<ResourceType> resourceClass) {
        return new RequestBuilder<ResourceType>(this.glide, this, resourceClass);
    }

    public void clear(View view) {
        this.clear(new ClearTarget(view));
    }

    public void clear(final @Nullable Target<?> target) {
        if (target == null) {
            return;
        }
        if (Util.isOnMainThread()) {
            this.untrackOrDelegate(target);
        } else {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    RequestManager.this.clear(target);
                }
            });
        }
    }

    private void untrackOrDelegate(Target<?> target) {
        boolean isOwnedByUs = this.untrack(target);
        if (!isOwnedByUs) {
            this.glide.removeFromManagers(target);
        }
    }

    boolean untrack(Target<?> target) {
        Request request = target.getRequest();
        if (request == null) {
            return true;
        }
        if (this.requestTracker.clearRemoveAndRecycle(request)) {
            this.targetTracker.untrack(target);
            target.setRequest(null);
            return true;
        }
        return false;
    }

    void track(Target<?> target, Request request) {
        this.targetTracker.track(target);
        this.requestTracker.runRequest(request);
    }

    RequestOptions getDefaultRequestOptions() {
        return this.requestOptions;
    }

    @NonNull
    <T> TransitionOptions<?, T> getDefaultTransitionOptions(Class<T> transcodeClass) {
        return this.glide.getGlideContext().getDefaultTransitionOptions(transcodeClass);
    }

    public String toString() {
        return super.toString() + "{tracker=" + this.requestTracker + ", treeNode=" + this.treeNode + "}";
    }

    private static class ClearTarget
    extends ViewTarget<View, Object> {
        public ClearTarget(View view) {
            super(view);
        }

        @Override
        public void onResourceReady(Object resource, Transition<? super Object> transition) {
        }
    }

    private static class RequestManagerConnectivityListener
    implements ConnectivityMonitor.ConnectivityListener {
        private final RequestTracker requestTracker;

        public RequestManagerConnectivityListener(RequestTracker requestTracker) {
            this.requestTracker = requestTracker;
        }

        @Override
        public void onConnectivityChanged(boolean isConnected) {
            if (isConnected) {
                this.requestTracker.restartRequests();
            }
        }
    }
}

