/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.ActivityLifecycleHandler;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.UserUpdateBatcher;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.SimpleActivityLifecycleCallbacks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class LifecycleTracker
extends SimpleActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private final SystemNotificationManager systemNotificationManager;
    private final Set<Integer> startedActivities = new HashSet<Integer>();
    private final MetricsStore metricsStore;
    private final DeDuper deDuper;
    private final TimeProvider timeProvider;
    private final UserUpdateBatcher userUpdateBatcher;
    final Store<State> store;
    private final ResetManager resetManager;
    private final ActivityLifecycleHandler handler;
    private final Twig twig = LumberMill.getLogger();

    static LifecycleTracker create(SystemNotificationManager systemNotificationManager, MetricsStore metricsStore, DeDuper deDuper, TimeProvider timeProvider, UserUpdateBatcher userUpdateBatcher, Store<State> store, ResetManager resetManager, float transitionScale) {
        return new LifecycleTracker(systemNotificationManager, metricsStore, deDuper, timeProvider, userUpdateBatcher, store, resetManager, new ActivityLifecycleHandler(Looper.getMainLooper(), store, transitionScale));
    }

    @VisibleForTesting
    LifecycleTracker(SystemNotificationManager systemNotificationManager, MetricsStore metricsStore, DeDuper deDuper, TimeProvider timeProvider, UserUpdateBatcher userUpdateBatcher, Store<State> store, ResetManager resetManager, ActivityLifecycleHandler handler) {
        this.systemNotificationManager = systemNotificationManager;
        this.metricsStore = metricsStore;
        this.deDuper = deDuper;
        this.timeProvider = timeProvider;
        this.userUpdateBatcher = userUpdateBatcher;
        this.store = store;
        this.resetManager = resetManager;
        this.handler = handler;
    }

    @Override
    public void onActivityStarted(Activity activity) {
        this.registerActivity(activity);
        if (this.store.select(Selectors.APP_IS_BACKGROUNDED).booleanValue()) {
            this.store.dispatch(Actions.appEnteredForeground(this.timeProvider.currentTimeMillis()));
            this.metricsStore.loadAndSendMetrics();
            this.systemNotificationManager.clear();
        }
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.handler.removeMessages(1, activity);
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(0, activity));
    }

    @Override
    public void onActivityPaused(Activity activity) {
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(2, activity));
    }

    @Override
    public void onActivityStopped(Activity activity) {
        this.unregisterActivity(activity);
        this.handler.removeMessages(1, activity);
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(3, activity));
        if (this.hasApplicationBecomeBackgrounded(activity)) {
            if (this.resetManager.isSoftReset()) {
                this.resetManager.hardReset();
            }
            this.store.dispatch(Actions.appEnteredBackground(this.timeProvider.currentTimeMillis()));
            this.deDuper.reset();
            this.userUpdateBatcher.submitPendingUpdate();
            this.metricsStore.loadAndSendMetrics();
        }
    }

    void registerActivities(Collection<Integer> hashCodes) {
        this.startedActivities.addAll(hashCodes);
    }

    private void registerActivity(Activity activity) {
        this.startedActivities.add(System.identityHashCode(activity));
        this.twig.i("Started observing " + activity, new Object[0]);
    }

    private void unregisterActivity(Activity activity) {
        this.startedActivities.remove(System.identityHashCode(activity));
        this.twig.i("Stopped observing " + activity, new Object[0]);
    }

    private boolean hasApplicationBecomeBackgrounded(Activity activity) {
        return this.isApplicationInBackground(activity) && this.store.select(Selectors.APP_IS_BACKGROUNDED) == false;
    }

    @VisibleForTesting
    boolean isApplicationInBackground(Activity activity) {
        return LifecycleTracker.isScreenLocked((Context)activity) || this.startedActivities.isEmpty() && !activity.isChangingConfigurations();
    }

    private static boolean isScreenLocked(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }
}

