/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.CustomAttributeValidator;
import java.util.HashMap;
import java.util.Map;

public class Company {
    private static final Twig TWIG = LumberMill.getLogger();
    private static final String COMPANY_ID = "id";
    private static final String NAME = "name";
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String CREATED_AT = "created_at";
    private static final String MONTHLY_SPEND = "monthly_spend";
    private static final String PLAN = "plan";
    private final Map<String, Object> attributes;
    private final Map<String, Object> customAttributes;

    Company(Builder builder) {
        this.attributes = builder.attributes;
        this.customAttributes = builder.customAttributes;
    }

    Map<String, Object> getAttributes() {
        if (!this.customAttributes.isEmpty()) {
            this.attributes.put(CUSTOM_ATTRIBUTES, this.customAttributes);
        }
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Company company = (Company)o;
        if (!this.attributes.equals(company.attributes)) {
            return false;
        }
        return this.customAttributes.equals(company.customAttributes);
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.customAttributes.hashCode();
        return result;
    }

    public String toString() {
        return "Company{attributes=" + this.attributes + ", customAttributes=" + this.customAttributes + '}';
    }

    public static final class Builder {
        final Map<String, Object> attributes = new HashMap<String, Object>();
        final Map<String, Object> customAttributes = new HashMap<String, Object>();

        public Company build() {
            return new Company(this);
        }

        public Builder withCompanyId(@Nullable String companyId) {
            this.attributes.put(Company.COMPANY_ID, companyId);
            return this;
        }

        public Builder withName(@Nullable String name) {
            this.attributes.put(Company.NAME, name);
            return this;
        }

        public Builder withCreatedAt(@Nullable Long createdAt) {
            this.attributes.put(Company.CREATED_AT, createdAt);
            return this;
        }

        public Builder withMonthlySpend(@Nullable Integer monthlySpend) {
            this.attributes.put(Company.MONTHLY_SPEND, monthlySpend);
            return this;
        }

        public Builder withPlan(@Nullable String plan) {
            this.attributes.put(Company.PLAN, plan);
            return this;
        }

        public Builder withCustomAttribute(@NonNull String key, @Nullable Object attribute) {
            if (key == null) {
                TWIG.w("The key you provided was null for the attribute " + attribute, new Object[0]);
            } else if (CustomAttributeValidator.isValid(attribute)) {
                this.customAttributes.put(key, attribute);
            } else {
                TWIG.w("The custom company attribute " + key + " was of type " + attribute.getClass().getSimpleName() + " We only accept the following types: " + CustomAttributeValidator.getAcceptedTypes(), new Object[0]);
            }
            return this;
        }

        public Builder withCustomAttributes(@NonNull Map<String, ?> attributes) {
            if (attributes == null) {
                TWIG.w("The map of attributes you provided was null.", new Object[0]);
            } else {
                for (Map.Entry<String, ?> attribute : attributes.entrySet()) {
                    if (CustomAttributeValidator.isValid(attribute.getValue())) {
                        this.customAttributes.put(attribute.getKey(), attribute.getValue());
                        continue;
                    }
                    TWIG.w("The custom company attribute " + attribute.getKey() + " was of type " + attribute.getClass().getSimpleName() + " We only accept the following types: " + CustomAttributeValidator.getAcceptedTypes(), new Object[0]);
                }
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            if (!this.attributes.equals(builder.attributes)) {
                return false;
            }
            return this.customAttributes.equals(builder.customAttributes);
        }

        public int hashCode() {
            int result = this.attributes.hashCode();
            result = 31 * result + this.customAttributes.hashCode();
            return result;
        }

        public String toString() {
            return "Builder{attributes=" + this.attributes + ", customAttributes=" + this.customAttributes + '}';
        }
    }
}

