/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.persistence;

import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.IoUtils;
import io.intercom.com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class JsonStorage {
    private static final Twig TWIG = LumberMill.getLogger();
    private final Gson gson;

    public JsonStorage(Gson gson) {
        this.gson = gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void loadThenDelete(File file, Class<T> clazz, LoadHandler<T> loadHandler) {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            loadHandler.receive(this.gson.fromJson((Reader)reader, clazz));
            IoUtils.safelyDelete(file);
        }
        catch (Exception e) {
            try {
                IoUtils.safelyDelete(file);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                throw throwable;
            }
            IoUtils.closeQuietly(reader);
        }
        IoUtils.closeQuietly(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void loadFilesInDirectory(File directory, Class<T> clazz, LoadHandler<List<T>> loadHandler) {
        FileReader reader = null;
        try {
            File[] files = directory.listFiles();
            ArrayList<Object> objects = new ArrayList<Object>(files.length);
            for (File file : files) {
                reader = new FileReader(file);
                objects.add(this.gson.fromJson((Reader)reader, clazz));
                IoUtils.closeQuietly(reader);
            }
            loadHandler.receive(objects);
        }
        catch (Exception e) {
            TWIG.internal("Couldn't load files: " + e);
        }
        finally {
            IoUtils.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFileAsJson(Object object, File file) {
        FileWriter writer = null;
        try {
            if (file.exists() && !file.delete()) {
                throw new RuntimeException("Couldn't delete existing file at " + file.getAbsolutePath());
            }
            File parentDir = file.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                throw new RuntimeException("Couldn't create missing parent dir at " + parentDir.getAbsolutePath());
            }
            writer = new FileWriter(file);
            this.gson.toJson(object, (Appendable)writer);
        }
        catch (Exception e) {
            try {
                TWIG.internal("Couldn't save file to disk: " + e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(writer);
                throw throwable;
            }
            IoUtils.closeQuietly(writer);
        }
        IoUtils.closeQuietly(writer);
    }

    public static interface LoadHandler<T> {
        public void receive(T var1);
    }
}

