/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipboardManager;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.views.holder.BlocksPartViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;

public class LinkViewHolder
extends BlocksPartViewHolder {
    private final int viewType;
    private final Provider<AppConfig> appConfigProvider;

    public LinkViewHolder(View itemView, int viewType, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, Provider<AppConfig> appConfigProvider) {
        super(itemView, conversationListener, clipboardManager);
        this.viewType = viewType;
        this.appConfigProvider = appConfigProvider;
        if (Build.VERSION.SDK_INT >= 21) {
            this.cellLayout.setTransitionName("link_background");
        }
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        ViewGroup blocks = this.setUpHolderBlocks(part, this.cellLayout, this.bubble, blocksLayout);
        this.checkForEntranceAnimation(this.viewType, part, this.networkAvatar, (View)this.cellLayout, blocks);
        if (this.networkAvatar != null) {
            this.showAvatar(part.getParticipant(), this.networkAvatar, this.appConfigProvider.get());
        }
    }

    public void onClick(View v) {
        int adapterPosition = this.getAdapterPosition();
        if (adapterPosition != -1) {
            this.conversationListener.onLinkClicked(adapterPosition, (View)this.cellLayout);
        }
    }
}

