/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Company;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.CustomAttributeValidator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class UserAttributes {
    private static final Twig TWIG = LumberMill.getLogger();
    private static final String EMAIL = "email";
    private static final String USER_ID = "user_id";
    private static final String NAME = "name";
    private static final String PHONE = "phone";
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String COMPANIES = "companies";
    private static final String SIGNED_UP_AT = "signed_up_at";
    private static final String UNSUBSCRIBED_FROM_EMAILS = "unsubscribed_from_emails";
    private static final String LANGUAGE_OVERRIDE = "language_override";
    private final Map<String, Object> attributes;
    private final Map<String, Object> customAttributes;
    private final List<Map<String, Object>> companies;

    UserAttributes(Builder builder) {
        this.attributes = builder.attributes;
        this.customAttributes = builder.customAttributes;
        this.companies = builder.companies;
    }

    Map<String, Object> toMap() {
        if (!this.customAttributes.isEmpty()) {
            this.attributes.put(CUSTOM_ATTRIBUTES, this.customAttributes);
        }
        if (!this.companies.isEmpty()) {
            this.attributes.put(COMPANIES, this.companies);
        }
        return this.attributes;
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty() && this.customAttributes.isEmpty() && this.companies.isEmpty();
    }

    public static final class Builder {
        final Map<String, Object> attributes = new HashMap<String, Object>();
        final Map<String, Object> customAttributes = new HashMap<String, Object>();
        final List<Map<String, Object>> companies = new ArrayList<Map<String, Object>>();

        public UserAttributes build() {
            return new UserAttributes(this);
        }

        public Builder withEmail(@Nullable String email) {
            this.attributes.put(UserAttributes.EMAIL, email);
            return this;
        }

        public Builder withUserId(@Nullable String userId) {
            this.attributes.put(UserAttributes.USER_ID, userId);
            return this;
        }

        public Builder withName(@Nullable String name) {
            this.attributes.put(UserAttributes.NAME, name);
            return this;
        }

        public Builder withPhone(@Nullable String phone) {
            this.attributes.put(UserAttributes.PHONE, phone);
            return this;
        }

        public Builder withSignedUpAt(@Nullable Long signedUpAt) {
            this.attributes.put(UserAttributes.SIGNED_UP_AT, signedUpAt);
            return this;
        }

        public Builder withSignedUpAt(@Nullable Date signedUpAt) {
            return this.withSignedUpAt(signedUpAt == null ? null : Long.valueOf(TimeUnit.MILLISECONDS.toSeconds(signedUpAt.getTime())));
        }

        public Builder withUnsubscribedFromEmails(@Nullable Boolean unsubscribedFromEmails) {
            this.attributes.put(UserAttributes.UNSUBSCRIBED_FROM_EMAILS, unsubscribedFromEmails);
            return this;
        }

        public Builder withLanguageOverride(@Nullable String languageOverride) {
            this.attributes.put(UserAttributes.LANGUAGE_OVERRIDE, languageOverride);
            return this;
        }

        public Builder withCompany(@NonNull Company company) {
            if (company == null) {
                TWIG.w("The company you provided was null", new Object[0]);
            } else {
                this.companies.add(company.getAttributes());
            }
            return this;
        }

        public Builder withCustomAttribute(@NonNull String key, @Nullable Object attribute) {
            if (key == null) {
                TWIG.w("The key you provided was null for the attribute " + attribute, new Object[0]);
            } else if (CustomAttributeValidator.isValid(attribute)) {
                this.customAttributes.put(key, attribute);
            } else {
                TWIG.w("The custom user attribute " + key + " was of type " + attribute.getClass().getSimpleName() + " We only accept the following types: " + CustomAttributeValidator.getAcceptedTypes(), new Object[0]);
            }
            return this;
        }

        public Builder withCustomAttributes(@NonNull Map<String, ?> attributes) {
            if (attributes == null) {
                TWIG.w("The map of attributes you provided was null.", new Object[0]);
            } else {
                for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                    Object attribute = entry.getValue();
                    if (CustomAttributeValidator.isValid(attribute)) {
                        this.customAttributes.put(entry.getKey(), attribute);
                        continue;
                    }
                    TWIG.w("The custom user attribute " + entry.getKey() + " was of type " + attribute.getClass().getSimpleName() + " We only accept the following types: " + CustomAttributeValidator.getAcceptedTypes(), new Object[0]);
                }
            }
            return this;
        }
    }
}

