/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.request.target;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import io.intercom.com.bumptech.glide.request.target.SimpleTarget;
import io.intercom.com.bumptech.glide.request.transition.Transition;
import io.intercom.com.bumptech.glide.util.Preconditions;

public class NotificationTarget
extends SimpleTarget<Bitmap> {
    private final RemoteViews remoteViews;
    private final Context context;
    private final int notificationId;
    private final String notificationTag;
    private final Notification notification;
    private final int viewId;

    public NotificationTarget(Context context, int viewId, RemoteViews remoteViews, Notification notification, int notificationId) {
        this(context, viewId, remoteViews, notification, notificationId, null);
    }

    public NotificationTarget(Context context, int viewId, RemoteViews remoteViews, Notification notification, int notificationId, String notificationTag) {
        this(context, Integer.MIN_VALUE, Integer.MIN_VALUE, viewId, remoteViews, notification, notificationId, notificationTag);
    }

    public NotificationTarget(Context context, int width, int height, int viewId, RemoteViews remoteViews, Notification notification, int notificationId, String notificationTag) {
        super(width, height);
        this.context = Preconditions.checkNotNull(context, "Context must not be null!");
        this.notification = Preconditions.checkNotNull(notification, "Notification object can not be null!");
        this.remoteViews = Preconditions.checkNotNull(remoteViews, "RemoteViews object can not be null!");
        this.viewId = viewId;
        this.notificationId = notificationId;
        this.notificationTag = notificationTag;
    }

    private void update() {
        NotificationManager manager = (NotificationManager)this.context.getSystemService("notification");
        manager.notify(this.notificationTag, this.notificationId, this.notification);
    }

    @Override
    public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
        this.remoteViews.setImageViewBitmap(this.viewId, resource);
        this.update();
    }
}

