/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.bitmap;

import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RecyclableBufferedInputStream
extends FilterInputStream {
    private volatile byte[] buf;
    private int count;
    private int marklimit;
    private int markpos = -1;
    private int pos;
    private final ArrayPool byteArrayPool;

    public RecyclableBufferedInputStream(InputStream in, ArrayPool byteArrayPool) {
        this(in, byteArrayPool, 65536);
    }

    RecyclableBufferedInputStream(InputStream in, ArrayPool byteArrayPool, int bufferSize) {
        super(in);
        this.byteArrayPool = byteArrayPool;
        this.buf = byteArrayPool.get(bufferSize, byte[].class);
    }

    @Override
    public synchronized int available() throws IOException {
        InputStream localIn = this.in;
        if (this.buf == null || localIn == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        return this.count - this.pos + localIn.available();
    }

    private static IOException streamClosed() throws IOException {
        throw new IOException("BufferedInputStream is closed");
    }

    public synchronized void fixMarkLimit() {
        this.marklimit = this.buf.length;
    }

    public synchronized void release() {
        if (this.buf != null) {
            this.byteArrayPool.put(this.buf, byte[].class);
            this.buf = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            this.byteArrayPool.put(this.buf, byte[].class);
            this.buf = null;
        }
        InputStream localIn = this.in;
        this.in = null;
        if (localIn != null) {
            localIn.close();
        }
    }

    private int fillbuf(InputStream localIn, byte[] localBuf) throws IOException {
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int result = localIn.read(localBuf);
            if (result > 0) {
                this.markpos = -1;
                this.pos = 0;
                this.count = result;
            }
            return result;
        }
        if (this.markpos == 0 && this.marklimit > localBuf.length && this.count == localBuf.length) {
            int newLength = localBuf.length * 2;
            if (newLength > this.marklimit) {
                newLength = this.marklimit;
            }
            byte[] newbuf = this.byteArrayPool.get(newLength, byte[].class);
            System.arraycopy(localBuf, 0, newbuf, 0, localBuf.length);
            byte[] oldbuf = localBuf;
            this.buf = newbuf;
            localBuf = newbuf;
            this.byteArrayPool.put(oldbuf, byte[].class);
        } else if (this.markpos > 0) {
            System.arraycopy(localBuf, this.markpos, localBuf, 0, localBuf.length - this.markpos);
        }
        this.pos -= this.markpos;
        this.markpos = 0;
        this.count = 0;
        int bytesread = localIn.read(localBuf, this.pos, localBuf.length - this.pos);
        this.count = bytesread <= 0 ? this.pos : this.pos + bytesread;
        return bytesread;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marklimit = Math.max(this.marklimit, readlimit);
        this.markpos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] localBuf = this.buf;
        InputStream localIn = this.in;
        if (localBuf == null || localIn == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (this.pos >= this.count && this.fillbuf(localIn, localBuf) == -1) {
            return -1;
        }
        if (localBuf != this.buf && (localBuf = this.buf) == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (this.count - this.pos > 0) {
            return localBuf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int byteCount) throws IOException {
        int required;
        byte[] localBuf = this.buf;
        if (localBuf == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (byteCount == 0) {
            return 0;
        }
        InputStream localIn = this.in;
        if (localIn == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (this.pos < this.count) {
            int copylength = this.count - this.pos >= byteCount ? byteCount : this.count - this.pos;
            System.arraycopy(localBuf, this.pos, buffer, offset, copylength);
            this.pos += copylength;
            if (copylength == byteCount || localIn.available() == 0) {
                return copylength;
            }
            offset += copylength;
            required = byteCount - copylength;
        } else {
            required = byteCount;
        }
        while (true) {
            int read;
            if (this.markpos == -1 && required >= localBuf.length) {
                read = localIn.read(buffer, offset, required);
                if (read == -1) {
                    return required == byteCount ? -1 : byteCount - required;
                }
            } else {
                if (this.fillbuf(localIn, localBuf) == -1) {
                    return required == byteCount ? -1 : byteCount - required;
                }
                if (localBuf != this.buf && (localBuf = this.buf) == null) {
                    throw RecyclableBufferedInputStream.streamClosed();
                }
                read = this.count - this.pos >= required ? required : this.count - this.pos;
                System.arraycopy(localBuf, this.pos, buffer, offset, read);
                this.pos += read;
            }
            if ((required -= read) == 0) {
                return byteCount;
            }
            if (localIn.available() == 0) {
                return byteCount - required;
            }
            offset += read;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        if (-1 == this.markpos) {
            throw new InvalidMarkException("Mark has been invalidated, pos: " + this.pos + " markLimit: " + this.marklimit);
        }
        this.pos = this.markpos;
    }

    @Override
    public synchronized long skip(long byteCount) throws IOException {
        byte[] localBuf = this.buf;
        InputStream localIn = this.in;
        if (localBuf == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (byteCount < 1L) {
            return 0L;
        }
        if (localIn == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if ((long)(this.count - this.pos) >= byteCount) {
            this.pos = (int)((long)this.pos + byteCount);
            return byteCount;
        }
        long read = this.count - this.pos;
        this.pos = this.count;
        if (this.markpos != -1 && byteCount <= (long)this.marklimit) {
            if (this.fillbuf(localIn, localBuf) == -1) {
                return read;
            }
            if ((long)(this.count - this.pos) >= byteCount - read) {
                this.pos = (int)((long)this.pos + (byteCount - read));
                return byteCount;
            }
            read = read + (long)this.count - (long)this.pos;
            this.pos = this.count;
            return read;
        }
        return read + localIn.skip(byteCount - read);
    }

    public static class InvalidMarkException
    extends IOException {
        private static final long serialVersionUID = -4338378848813561757L;

        public InvalidMarkException(String detailMessage) {
            super(detailMessage);
        }
    }
}

