/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.DecodeFormat;
import io.intercom.com.bumptech.glide.load.engine.Engine;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPoolAdapter;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.LruArrayPool;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import io.intercom.com.bumptech.glide.load.engine.cache.DiskCache;
import io.intercom.com.bumptech.glide.load.engine.cache.InternalCacheDiskCacheFactory;
import io.intercom.com.bumptech.glide.load.engine.cache.LruResourceCache;
import io.intercom.com.bumptech.glide.load.engine.cache.MemoryCache;
import io.intercom.com.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import io.intercom.com.bumptech.glide.load.engine.executor.GlideExecutor;
import io.intercom.com.bumptech.glide.manager.ConnectivityMonitorFactory;
import io.intercom.com.bumptech.glide.manager.DefaultConnectivityMonitorFactory;
import io.intercom.com.bumptech.glide.manager.RequestManagerRetriever;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import java.util.Map;

public final class GlideBuilder {
    private final Map<Class<?>, TransitionOptions<?, ?>> defaultTransitionOptions = new ArrayMap();
    private Engine engine;
    private BitmapPool bitmapPool;
    private ArrayPool arrayPool;
    private MemoryCache memoryCache;
    private GlideExecutor sourceExecutor;
    private GlideExecutor diskCacheExecutor;
    private DiskCache.Factory diskCacheFactory;
    private MemorySizeCalculator memorySizeCalculator;
    private ConnectivityMonitorFactory connectivityMonitorFactory;
    private int logLevel = 4;
    private RequestOptions defaultRequestOptions = new RequestOptions();
    @Nullable
    private RequestManagerRetriever.RequestManagerFactory requestManagerFactory;

    public GlideBuilder setBitmapPool(BitmapPool bitmapPool) {
        this.bitmapPool = bitmapPool;
        return this;
    }

    public GlideBuilder setArrayPool(ArrayPool arrayPool) {
        this.arrayPool = arrayPool;
        return this;
    }

    public GlideBuilder setMemoryCache(MemoryCache memoryCache) {
        this.memoryCache = memoryCache;
        return this;
    }

    @Deprecated
    public GlideBuilder setDiskCache(final DiskCache diskCache) {
        return this.setDiskCache(new DiskCache.Factory(){

            @Override
            public DiskCache build() {
                return diskCache;
            }
        });
    }

    public GlideBuilder setDiskCache(DiskCache.Factory diskCacheFactory) {
        this.diskCacheFactory = diskCacheFactory;
        return this;
    }

    public GlideBuilder setResizeExecutor(GlideExecutor service) {
        this.sourceExecutor = service;
        return this;
    }

    public GlideBuilder setDiskCacheExecutor(GlideExecutor service) {
        this.diskCacheExecutor = service;
        return this;
    }

    public GlideBuilder setDefaultRequestOptions(RequestOptions requestOptions) {
        this.defaultRequestOptions = requestOptions;
        return this;
    }

    public <T> GlideBuilder setDefaultTransitionOptions(@NonNull Class<T> clazz, @Nullable TransitionOptions<?, T> options) {
        this.defaultTransitionOptions.put(clazz, options);
        return this;
    }

    @Deprecated
    public GlideBuilder setDecodeFormat(DecodeFormat decodeFormat) {
        this.defaultRequestOptions = this.defaultRequestOptions.apply(new RequestOptions().format(decodeFormat));
        return this;
    }

    public GlideBuilder setMemorySizeCalculator(MemorySizeCalculator.Builder builder) {
        return this.setMemorySizeCalculator(builder.build());
    }

    public GlideBuilder setMemorySizeCalculator(MemorySizeCalculator calculator) {
        this.memorySizeCalculator = calculator;
        return this;
    }

    public GlideBuilder setConnectivityMonitorFactory(ConnectivityMonitorFactory factory) {
        this.connectivityMonitorFactory = factory;
        return this;
    }

    public GlideBuilder setLogLevel(int logLevel) {
        if (logLevel < 2 || logLevel > 6) {
            throw new IllegalArgumentException("Log level must be one of Log.VERBOSE, Log.DEBUG, Log.INFO, Log.WARN, or Log.ERROR");
        }
        this.logLevel = logLevel;
        return this;
    }

    GlideBuilder setRequestManagerFactory(@Nullable RequestManagerRetriever.RequestManagerFactory factory) {
        this.requestManagerFactory = factory;
        return this;
    }

    GlideBuilder setEngine(Engine engine) {
        this.engine = engine;
        return this;
    }

    public Glide build(Context context) {
        if (this.sourceExecutor == null) {
            this.sourceExecutor = GlideExecutor.newSourceExecutor();
        }
        if (this.diskCacheExecutor == null) {
            this.diskCacheExecutor = GlideExecutor.newDiskCacheExecutor();
        }
        if (this.memorySizeCalculator == null) {
            this.memorySizeCalculator = new MemorySizeCalculator.Builder(context).build();
        }
        if (this.connectivityMonitorFactory == null) {
            this.connectivityMonitorFactory = new DefaultConnectivityMonitorFactory();
        }
        if (this.bitmapPool == null) {
            int size = this.memorySizeCalculator.getBitmapPoolSize();
            this.bitmapPool = size > 0 ? new LruBitmapPool(size) : new BitmapPoolAdapter();
        }
        if (this.arrayPool == null) {
            this.arrayPool = new LruArrayPool(this.memorySizeCalculator.getArrayPoolSizeInBytes());
        }
        if (this.memoryCache == null) {
            this.memoryCache = new LruResourceCache(this.memorySizeCalculator.getMemoryCacheSize());
        }
        if (this.diskCacheFactory == null) {
            this.diskCacheFactory = new InternalCacheDiskCacheFactory(context);
        }
        if (this.engine == null) {
            this.engine = new Engine(this.memoryCache, this.diskCacheFactory, this.diskCacheExecutor, this.sourceExecutor, GlideExecutor.newUnlimitedSourceExecutor());
        }
        RequestManagerRetriever requestManagerRetriever = new RequestManagerRetriever(this.requestManagerFactory);
        return new Glide(context, this.engine, this.memoryCache, this.bitmapPool, this.arrayPool, requestManagerRetriever, this.connectivityMonitorFactory, this.logLevel, this.defaultRequestOptions.lock(), this.defaultTransitionOptions);
    }
}

